/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo;

import com.dgrossmann.photo.ui.ExplorerMainFrame;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import java.util.StringTokenizer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Main {
    private static final int LOAD_DEFAULT_UI = 0;
    private static final int LOAD_SYSTEM_UI = 1;
    private static final int LOAD_MOTIF_UI = 2;
    private static final int LOAD_METAL_UI = 3;
    private static final int LOAD_DIRECT_UI = 5;

    public static void main(String[] args) {
        String loadUIClass = null;
        int loadUI = 0;
        boolean bUILoaded = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-ui") || i >= args.length - 1) continue;
            if ((loadUIClass = args[++i]).equalsIgnoreCase("system") || loadUIClass.equalsIgnoreCase("windows")) {
                loadUI = 1;
                loadUIClass = null;
                continue;
            }
            if (loadUIClass.equalsIgnoreCase("motif")) {
                loadUI = 2;
                loadUIClass = null;
                continue;
            }
            if (loadUIClass.equalsIgnoreCase("metal")) {
                loadUI = 3;
                loadUIClass = null;
                continue;
            }
            loadUI = 5;
        }
        String osName = System.getProperty("os.name");
        if (loadUI == 1 || loadUI == 0 && osName != null && osName.equalsIgnoreCase("Windows XP")) {
            boolean bLoadCond;
            if (loadUI == 1) {
                bLoadCond = true;
            } else {
                StringTokenizer tok;
                bLoadCond = false;
                String javaVersion = System.getProperty("java.version");
                int index = javaVersion.indexOf("_");
                if (index > 0) {
                    javaVersion = javaVersion.substring(0, index);
                }
                if ((tok = new StringTokenizer(javaVersion, ".")).countTokens() >= 3) {
                    try {
                        float vers = Float.parseFloat(tok.nextToken() + "." + tok.nextToken() + tok.nextToken());
                        if (vers >= 1.42f) {
                            bLoadCond = true;
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
            try {
                if (bLoadCond) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    bUILoaded = true;
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (!bUILoaded && loadUI == 2) {
            try {
                UIManager.setLookAndFeel(new MotifLookAndFeel());
                bUILoaded = true;
            }
            catch (UnsupportedLookAndFeelException ignored) {
                // empty catch block
            }
        }
        if (!bUILoaded && loadUI == 5 && loadUIClass != null) {
            try {
                Object plf = Class.forName(loadUIClass).newInstance();
                if (plf instanceof LookAndFeel) {
                    UIManager.setLookAndFeel((LookAndFeel)plf);
                    bUILoaded = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        new ExplorerMainFrame();
    }
}

