/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.dir;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.FileObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class DirectoryObject
extends AbstractFSObject {
    private ArrayList<DirectoryObject> m_subDirectories;
    private ArrayList<FileObject> m_files;
    private boolean m_isChanged;
    private boolean m_isError;

    public DirectoryObject(String name, DirectoryObject parentDirObj) {
        super(parentDirObj);
        this.setFileName(name, false);
        this.m_subDirectories = new ArrayList(10);
        this.m_files = new ArrayList(40);
        this.m_isError = false;
        this.m_isChanged = false;
    }

    @Override
    public boolean isEmpty() {
        File dir = new File(this.getFullPath());
        return !dir.isDirectory() || dir.list() == null;
    }

    @Override
    public String getFileName() {
        String name = super.getFileName();
        if (name.length() == 0 || this.getParent() != null) {
            return name;
        }
        int i = name.lastIndexOf(File.separator);
        if (i < 0) {
            i = name.lastIndexOf("/");
        }
        return i >= 0 && i < name.length() - 1 ? name.substring(i + 1) : name;
    }

    public int getSubDirCount() {
        return this.m_subDirectories.size();
    }

    public DirectoryObject getSubDirAt(int i) {
        if (i < 0 || i >= this.m_subDirectories.size()) {
            return null;
        }
        return this.m_subDirectories.get(i);
    }

    public int getIndexOfSubDir(DirectoryObject subDirObj) {
        return this.m_subDirectories.indexOf(subDirObj);
    }

    public Iterator<DirectoryObject> getSubDirIterator() {
        return this.m_subDirectories.iterator();
    }

    public int getFileCount() {
        return this.m_files.size();
    }

    public FileObject getFileAt(int i) {
        if (i < 0 || i >= this.m_files.size()) {
            return null;
        }
        return this.m_files.get(i);
    }

    public int getIndexOfFile(FileObject fileObj) {
        return this.m_files.indexOf(fileObj);
    }

    public Iterator<FileObject> getFileIterator() {
        return this.m_files.iterator();
    }

    public boolean addChild(AbstractFSObject fsObj, int index) {
        FileObject f;
        DirectoryObject oldParent = null;
        int oldIndex = -1;
        File oldFile = null;
        DirectoryObject d = fsObj instanceof DirectoryObject ? (DirectoryObject)fsObj : null;
        FileObject fileObject = f = fsObj instanceof FileObject ? (FileObject)fsObj : null;
        if (d == null && f == null) {
            return false;
        }
        oldParent = (DirectoryObject)fsObj.getParent();
        if (oldParent != null) {
            if (fsObj.getFileName().length() > 0) {
                oldIndex = d != null ? oldParent.getIndexOfSubDir(d) : oldParent.getIndexOfFile(f);
                oldFile = new File(fsObj.getFullPath());
            }
            if (d != null) {
                oldParent.removeSubDir(d);
            } else {
                oldParent.removeFile(f);
            }
        }
        fsObj.m_parent = this;
        if (d != null) {
            if (index < 0 || index > this.m_subDirectories.size()) {
                this.m_subDirectories.add(d);
            } else {
                this.m_subDirectories.add(index, d);
            }
        } else if (index < 0 || index > this.m_files.size()) {
            this.m_files.add(f);
        } else {
            this.m_files.add(index, f);
        }
        this.setChanged();
        if (oldFile != null) {
            if (oldFile.renameTo(new File(fsObj.getFullPath()))) {
                return true;
            }
            fsObj.m_parent = null;
            if (d != null) {
                this.removeSubDir(d);
            } else {
                this.removeFile(f);
            }
            oldParent.addChild(fsObj, oldIndex);
            return false;
        }
        return true;
    }

    public void removeSubDir(DirectoryObject dirObj) {
        this.setChanged();
        this.m_subDirectories.remove(dirObj);
    }

    public void removeFile(FileObject fileObj) {
        this.setChanged();
        this.m_files.remove(fileObj);
    }

    public boolean canMoveUp(AbstractFSObject fsObj) {
        if (fsObj instanceof DirectoryObject) {
            int index = this.m_subDirectories.indexOf(fsObj);
            return index > 0 && index < this.m_subDirectories.size();
        }
        if (fsObj instanceof FileObject) {
            int index = this.m_files.indexOf(fsObj);
            return index > 0 && index < this.m_files.size();
        }
        return false;
    }

    public boolean canMoveDown(AbstractFSObject fsObj) {
        if (fsObj instanceof DirectoryObject) {
            int index = this.m_subDirectories.indexOf(fsObj);
            return index >= 0 && index < this.m_subDirectories.size() - 1;
        }
        if (fsObj instanceof FileObject) {
            int index = this.m_files.indexOf(fsObj);
            return index >= 0 && index < this.m_files.size() - 1;
        }
        return false;
    }

    public void moveFileUp(FileObject fileObj) {
        int index = this.m_files.indexOf(fileObj);
        if (index <= 0 || index >= this.m_files.size()) {
            return;
        }
        FileObject eBefore = this.m_files.get(index - 1);
        this.m_files.set(index - 1, fileObj);
        this.m_files.set(index, eBefore);
        this.setChanged();
    }

    public void moveFileDown(FileObject fileObj) {
        int index = this.m_files.indexOf(fileObj);
        if (index < 0 || index >= this.m_files.size() - 1) {
            return;
        }
        FileObject eAfter = this.m_files.get(index + 1);
        this.m_files.set(index + 1, fileObj);
        this.m_files.set(index, eAfter);
        this.setChanged();
    }

    public void moveSubDirUp(DirectoryObject dirObj) {
        int index = this.m_subDirectories.indexOf(dirObj);
        if (index <= 0 || index >= this.m_subDirectories.size()) {
            return;
        }
        DirectoryObject eBefore = this.m_subDirectories.get(index - 1);
        this.m_subDirectories.set(index - 1, dirObj);
        this.m_subDirectories.set(index, eBefore);
        this.setChanged();
    }

    public void moveSubDirDown(DirectoryObject dirObj) {
        int index = this.m_subDirectories.indexOf(dirObj);
        if (index < 0 || index >= this.m_subDirectories.size() - 1) {
            return;
        }
        DirectoryObject eAfter = this.m_subDirectories.get(index + 1);
        this.m_subDirectories.set(index + 1, dirObj);
        this.m_subDirectories.set(index, eAfter);
        this.setChanged();
    }

    public void orderFilesByFileName() {
        Collections.sort(this.m_files, new Comparator<FileObject>(){

            @Override
            public int compare(FileObject file1, FileObject file2) {
                if (file1 == file2) {
                    return 0;
                }
                if (file1 == null) {
                    return file2 == null ? 0 : -1;
                }
                if (file2 == null) {
                    return 1;
                }
                if (file1.getFileName() == null) {
                    return file2.getFileName() == null ? 0 : -1;
                }
                return file1.getFileName().compareTo(file2.getFileName());
            }
        });
    }

    public void clear() {
        this.m_subDirectories.clear();
        this.m_files.clear();
        this.setChanged();
    }

    public void setChanged() {
        if (this.getParent() != null) {
            ((DirectoryObject)this.getParent()).setChanged();
        } else {
            this.m_isChanged = true;
        }
    }

    public void setSaved() {
        if (this.getParent() != null) {
            ((DirectoryObject)this.getParent()).setChanged();
        } else {
            this.m_isChanged = false;
        }
    }

    public boolean isChanged() {
        DirectoryObject dirObj = this;
        while (dirObj.getParent() != null) {
            dirObj = (DirectoryObject)dirObj.getParent();
        }
        return dirObj.m_isChanged;
    }

    public void setError() {
        if (this.getParent() != null) {
            ((DirectoryObject)this.getParent()).setChanged();
        } else {
            this.m_isError = true;
        }
    }

    public boolean isError() {
        DirectoryObject dirObj = this;
        while (dirObj.getParent() != null) {
            dirObj = (DirectoryObject)dirObj.getParent();
        }
        return dirObj.m_isError;
    }

    private boolean deleteDir(String dirPath, boolean bForce) {
        File thisFile = new File(dirPath);
        String[] subObjNames = thisFile.list();
        if (subObjNames == null) {
            return true;
        }
        for (int i = 0; i < subObjNames.length; ++i) {
            if (subObjNames[i].equals(".") || subObjNames[i].equals("..")) continue;
            File f = new File(dirPath + File.separator + subObjNames[i]);
            if (f.isFile()) {
                if (bForce && f.delete()) continue;
                return false;
            }
            if (f.isDirectory()) {
                if (this.deleteDir(dirPath + File.separator + subObjNames[i], bForce)) continue;
                return false;
            }
            return false;
        }
        return thisFile.delete();
    }

    public boolean delete(boolean bForce) {
        this.m_subDirectories.clear();
        this.m_files.clear();
        boolean bOK = this.deleteDir(this.getFullPath(), bForce);
        if (bOK) {
            if (this.m_parent != null) {
                ((DirectoryObject)this.m_parent).removeSubDir(this);
            }
            this.m_fileName = "";
            this.setChanged();
        }
        return bOK;
    }
}

