/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui;

import com.dgrossmann.photo.AppInfo;
import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.dir.SeriesContainer;
import com.dgrossmann.photo.dir.persist.PersistException;
import com.dgrossmann.photo.dir.persist.PersistFactory;
import com.dgrossmann.photo.settings.Settings;
import com.dgrossmann.photo.ui.ExportTimerTask;
import com.dgrossmann.photo.ui.ImageHolder;
import com.dgrossmann.photo.ui.dialog.AboutDialog;
import com.dgrossmann.photo.ui.dialog.EnterDirNameDialog;
import com.dgrossmann.photo.ui.dialog.ExportProgressDialog;
import com.dgrossmann.photo.ui.dialog.ExportSelDialog;
import com.dgrossmann.photo.ui.dialog.PropertiesDialog;
import com.dgrossmann.photo.ui.dialog.SettingsDialog;
import com.dgrossmann.photo.ui.panel.DirTreePanel;
import com.dgrossmann.photo.ui.panel.IExplorerPanel;
import com.dgrossmann.photo.ui.panel.IExplorerPanelChangeListener;
import com.dgrossmann.photo.ui.panel.PropertyPanel;
import com.dgrossmann.photo.ui.panel.contents.ContentsPanel;
import com.dgrossmann.photo.webexport.ExportFactory;
import com.dgrossmann.photo.webexport.ExportProgress;
import com.dgrossmann.photo.webexport.ExportThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreePath;

public class ExplorerMainFrame
extends JFrame
implements IExplorerPanelChangeListener {
    static final String HELPSET_NAME = "MainHelp";
    static final String MAIN_WIN_POS = "main.window.pos";
    static final String MAIN_WIN_MAXIMIZED = "main.window.maximized";
    static final String MAIN_WIN_DIR_SPLIT_POS = "main.window.dir_split_pos";
    static final String MAIN_WIN_PROP_SPLIT_POS = "main.window.prop_split_pos";
    private Settings m_settings;
    private SeriesContainer m_seriesContainer;
    private ImageHolder m_imgHolder;
    private DirectoryObject m_currentDir = null;
    private List<AbstractFSObject> m_objsToPaste = new ArrayList<AbstractFSObject>(40);
    private DirTreePanel m_dirTreePanel;
    private IExplorerPanel m_propertyPanel;
    private ContentsPanel m_dirContentsPanel;
    private JMenuItem m_helpContentsMenuItem;
    private JMenuItem m_aboutMenuItem;
    private HelpSet m_mainHS;
    private HelpBroker m_mainHB;
    private String m_helpError;
    public Boolean m_exportReady;
    public ExportProgress m_exportProgress;
    public Timer m_exportTimer;
    public String m_exportError;
    public boolean m_exportStop;
    public JPanel contentsPanel;
    public JPanel dirPanel;
    public JSplitPane dirSplitPane;
    public JMenuItem exitMenuItem;
    public JMenuItem exportMenuItem;
    public JMenu helpMenu;
    public JSeparator jSeparator1;
    public JSeparator jSeparator2;
    public JMenuBar menuBar;
    public JMenuItem prefsMenuItem;
    public JSplitPane propSplitPane;
    public JPanel propertyPanel;
    public JMenuItem refreshMenuItem;
    public JMenu seriesMenu;
    public JLabel statusBar;
    public JMenu viewMenu;

    public ExplorerMainFrame() {
        Rectangle frameRect;
        this.m_settings = new Settings("jphoto-explorer.properties");
        PersistFactory.loadSettings(this.m_settings);
        this.m_seriesContainer = new SeriesContainer(this.m_settings);
        this.m_imgHolder = new ImageHolder();
        this.m_exportReady = new Boolean(true);
        this.m_exportProgress = null;
        this.m_exportTimer = null;
        this.m_exportStop = false;
        this.initComponents();
        this.m_dirTreePanel = new DirTreePanel(this);
        this.dirPanel.add((Component)this.m_dirTreePanel.getRootComponent(), "Center");
        this.m_propertyPanel = new PropertyPanel(this);
        this.propertyPanel.add((Component)this.m_propertyPanel.getRootComponent(), "Center");
        this.m_dirContentsPanel = new ContentsPanel(this);
        this.contentsPanel.add((Component)this.m_dirContentsPanel.getRootComponent(), "Center");
        this.m_dirTreePanel.addChangeListener(this);
        this.m_propertyPanel.addChangeListener(this);
        this.m_dirContentsPanel.addChangeListener(this);
        this.setStatusText();
        this.m_helpError = "";
        this.m_mainHS = null;
        this.m_mainHB = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = HelpSet.findHelpSet(cl, HELPSET_NAME);
            this.m_mainHS = new HelpSet(cl, url);
        }
        catch (NoClassDefFoundError nce) {
            this.m_helpError = "JavaHelp classes not found: " + nce.getMessage();
            System.err.println("E: " + this.m_helpError);
        }
        catch (Exception ee) {
            this.m_helpError = "Help Set \"MainHelp\" not found.";
            System.err.println("E: " + this.m_helpError);
        }
        catch (ExceptionInInitializerError ex) {
            this.m_helpError = "Help system initialization error:\n" + ex.toString();
            System.err.println("E: " + this.m_helpError);
            ex.getException().printStackTrace();
        }
        if (this.m_mainHS != null) {
            this.m_mainHB = this.m_mainHS.createHelpBroker();
            this.m_mainHB.enableHelpKey(this, "top", null);
        }
        if (this.m_mainHB != null) {
            this.m_helpContentsMenuItem = new JMenuItem("Help Contents");
            this.m_helpContentsMenuItem.addActionListener(new CSH.DisplayHelpFromSource(this.m_mainHB));
        } else {
            this.m_helpContentsMenuItem = null;
        }
        this.m_aboutMenuItem = new JMenuItem("About J Photo-Explorer ...");
        this.m_aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplorerMainFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        if (this.m_helpContentsMenuItem != null) {
            this.helpMenu.add(this.m_helpContentsMenuItem);
            JSeparator sep = new JSeparator();
            sep.setBackground(new Color(255, 255, 255));
            sep.setForeground(new Color(153, 153, 153));
            this.helpMenu.add(sep);
        }
        this.helpMenu.add(this.m_aboutMenuItem);
        this.setTitle("J Photo-Explorer");
        ImageIcon img = ImageHolder.loadStandardImage("images/app-logo.gif", this);
        if (img != null) {
            this.setIconImage(img.getImage());
        }
        if ((frameRect = this.m_settings.getRect(MAIN_WIN_POS)) == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            frameRect = new Rectangle();
            frameRect.width = screenSize.width;
            frameRect.height = screenSize.height - 34;
            frameRect.x = screenSize.width - frameRect.width;
            frameRect.y = screenSize.height - frameRect.height - 34;
        }
        this.setBounds(frameRect);
        if (this.m_settings.getBoolean(MAIN_WIN_MAXIMIZED, false)) {
            this.setState(6);
        }
        int dirSplitPos = this.m_settings.getInt(MAIN_WIN_DIR_SPLIT_POS, -1);
        int propSplitPos = this.m_settings.getInt(MAIN_WIN_PROP_SPLIT_POS, -1);
        if (dirSplitPos >= 0) {
            this.dirSplitPane.setDividerLocation(dirSplitPos);
        }
        if (propSplitPos >= 0) {
            this.propSplitPane.setDividerLocation(propSplitPos);
        }
        this.setVisible(true);
        String javaVersion = System.getProperty("java.version");
        boolean bJavaVersionOK = false;
        StringTokenizer tok = new StringTokenizer(javaVersion, ".");
        if (tok.countTokens() >= 2) {
            try {
                float vers = Float.parseFloat(tok.nextToken() + "." + tok.nextToken());
                bJavaVersionOK = vers >= 1.4f;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (!bJavaVersionOK) {
            String javaVendor = System.getProperty("java.vendor");
            String msg = "J Photo-Explorer needs Java Version 1.4 or higher.\n\nYou are using version " + javaVersion + " by " + javaVendor + "\n\nExit " + "J Photo-Explorer" + ".";
            JOptionPane.showMessageDialog(this, msg, "J Photo-Explorer", 0);
            System.exit(1);
        }
        if (this.m_mainHB == null) {
            System.err.println("   Class Path: " + System.getProperty("java.class.path"));
            JOptionPane.showMessageDialog(this, "Cannot show help." + (this.m_helpError.length() > 0 ? "\n" : "") + this.m_helpError + "\n\nClass Path: " + System.getProperty("java.class.path"), "J Photo-Explorer", 2);
        }
        if (!this.m_seriesContainer.hasSeriesDirectories()) {
            JOptionPane.showMessageDialog(this, "J Photo-Explorer does not have photo series directories. Please choose \"Series -> Settings...\"\nto define the directories that contain photo series directories.\n\nChoose \"Help -> Help Contents\" for help.", "J Photo-Explorer", 1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExplorerMainFrame.this.m_dirTreePanel.setupComponents();
                ExplorerMainFrame.this.m_propertyPanel.setupComponents();
                ExplorerMainFrame.this.m_dirContentsPanel.setupComponents();
                ExplorerMainFrame.this.m_dirTreePanel.loadSettings(ExplorerMainFrame.this.m_settings);
                ExplorerMainFrame.this.m_propertyPanel.loadSettings(ExplorerMainFrame.this.m_settings);
                ExplorerMainFrame.this.m_dirContentsPanel.loadSettings(ExplorerMainFrame.this.m_settings);
            }
        });
    }

    public Settings getSettings() {
        return this.m_settings;
    }

    public SeriesContainer getSeriesContainer() {
        return this.m_seriesContainer;
    }

    public ImageHolder getImageHolder() {
        return this.m_imgHolder;
    }

    public IExplorerPanel getDirContentsPanel() {
        return this.m_dirContentsPanel;
    }

    @Override
    public void onCurrentDirectoryChanged(IExplorerPanel source, DirectoryObject dirObj) {
        this.m_currentDir = dirObj;
        this.setStatusText();
        if (source == this.m_dirTreePanel) {
            this.m_dirContentsPanel.setCurrentDirectory(dirObj);
            this.m_propertyPanel.setCurrentFSObject(dirObj);
        } else if (source == this.m_dirContentsPanel) {
            this.m_dirTreePanel.setCurrentDirectory(dirObj);
            this.m_propertyPanel.setCurrentFSObject(dirObj);
        }
    }

    @Override
    public void onSelectionChanged(IExplorerPanel source, List<AbstractFSObject> newSelectedObjects) {
        if (source != this.m_propertyPanel) {
            this.m_propertyPanel.setCurrentFSObjects(newSelectedObjects);
        }
    }

    @Override
    public void onStructureChanged(IExplorerPanel source, DirectoryObject dirObj) {
        if (source != this.m_dirTreePanel) {
            this.m_dirTreePanel.onTreeStructureChanged(dirObj);
        }
    }

    @Override
    public void onPropertiesChanged(IExplorerPanel source, AbstractFSObject fsObj) {
        if (fsObj instanceof DirectoryObject && source != this.m_dirTreePanel) {
            this.m_dirTreePanel.onTreeStructureChanged((DirectoryObject)fsObj);
        }
        if (source != this.m_propertyPanel) {
            this.m_propertyPanel.refresh();
        }
        if (source != this.m_dirContentsPanel) {
            this.m_dirContentsPanel.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean newFile(DirectoryObject currentDir) {
        if (currentDir == null) {
            return false;
        }
        JFileChooser choose = new JFileChooser();
        choose.setDialogTitle("Choose File");
        choose.setDialogType(0);
        choose.setFileSelectionMode(0);
        choose.setApproveButtonToolTipText("Chooses the file to be copied to \"" + currentDir.getFileName() + "\"");
        JPanel addPanel = new JPanel(new GridLayout(5, 1));
        addPanel.setBorder(new TitledBorder(null, "Information", 0, 0, new Font("Dialog", 0, 11), new Color(51, 51, 153)));
        addPanel.add(new JLabel("The selected file"));
        addPanel.add(new JLabel("will be copied"));
        addPanel.add(new JLabel("into directory"));
        addPanel.add(new JLabel("\"" + currentDir.getFileName() + "\""));
        choose.setAccessory(addPanel);
        if (choose.showDialog(this, "Select") != 0) {
            return false;
        }
        File dirFile = choose.getSelectedFile();
        String fileName = dirFile.getName();
        String newName = currentDir.getFullPath() + File.separator + fileName;
        if (dirFile == null || !dirFile.isFile()) {
            return false;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        byte[] buf = new byte[32768];
        try {
            int len;
            in = new FileInputStream(dirFile);
            out = new FileOutputStream(newName);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Cannot copy file:\n   " + dirFile + "\nto:\n   " + newName + e, "J Photo-Explorer", 0);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exc) {}
        }
        FileObject fe = new FileObject(fileName, currentDir);
        fe.setReference(false);
        if (!this.finishFileObj(fe)) {
            dirFile = new File(newName);
            if (dirFile.exists()) {
                dirFile.delete();
            }
            return false;
        }
        return true;
    }

    public boolean newDirectory(DirectoryObject currentDir) {
        if (currentDir == null) {
            return false;
        }
        EnterDirNameDialog dlg = new EnterDirNameDialog((Frame)this, currentDir, true);
        if (!dlg.showDialog()) {
            return false;
        }
        String name = dlg.getDirName();
        File dir = new File(currentDir.getFullPath(), name);
        if (!dir.mkdir()) {
            JOptionPane.showMessageDialog(this, "Cannot create folder \"" + dir.getAbsolutePath() + "\"", "J Photo-Explorer", 0);
            return false;
        }
        DirectoryObject dirObj = new DirectoryObject(name, currentDir);
        return this.finishFileObj(dirObj);
    }

    public boolean finishFileObj(AbstractFSObject fsObj) {
        boolean bIsSeparator = false;
        if (fsObj instanceof FileObject && ((FileObject)fsObj).isSeparator()) {
            bIsSeparator = true;
        }
        if (!bIsSeparator) {
            PropertiesDialog dlg = new PropertiesDialog(this.m_imgHolder, fsObj, null, this, true);
            if (fsObj instanceof DirectoryObject) {
                dlg.setTitle("New Folder \"" + fsObj.getFileName() + "\"");
            } else if (fsObj.isReference()) {
                dlg.setTitle("New Reference");
            } else {
                dlg.setTitle("New File \"" + fsObj.getFileName() + "\"");
            }
            if (!dlg.showDialog()) {
                return false;
            }
        }
        if (fsObj instanceof DirectoryObject) {
            this.m_dirTreePanel.onTreeStructureChanged(this.m_currentDir);
        }
        this.m_dirContentsPanel.addNewFSObject(fsObj);
        return true;
    }

    public void setStatusText() {
        String txt;
        if (this.m_currentDir != null) {
            this.setTitle(this.m_currentDir.getTitlePlain() + " - " + "J Photo-Explorer");
        } else {
            this.setTitle("J Photo-Explorer");
        }
        this.statusBar.setForeground(new Color(0, 0, 0));
        if (this.m_objsToPaste.size() > 0) {
            txt = "  Cut: ";
            if (this.m_objsToPaste.size() == 1) {
                AbstractFSObject fsObj = this.m_objsToPaste.get(0);
                txt = txt + "\"" + fsObj.getTitle(true) + "\"";
                if (fsObj.isReference()) {
                    txt = txt + " (Reference)";
                } else {
                    txt = fsObj instanceof DirectoryObject ? txt + " (Directory " : txt + " (File ";
                    txt = txt + fsObj.getFullPath() + ")";
                }
            } else {
                txt = txt + "" + this.m_objsToPaste.size() + " objects";
            }
            this.statusBar.setForeground(new Color(51, 51, 153));
        } else if (this.m_currentDir != null) {
            txt = this.m_currentDir.getParent() == null ? "  Series " : "  Group ";
            txt = txt + (this.m_currentDir.getParent() == null || this.m_currentDir.getParent().getParent() == null ? this.m_currentDir.getFullPath() : this.m_currentDir.getPath(true));
            int subdirs = this.m_currentDir.getSubDirCount();
            int files = this.m_currentDir.getFileCount();
            txt = txt + " (" + subdirs + (subdirs != 1 ? " subdirectories" : " subdirectory") + ", " + files + (files != 1 ? " files" : " file") + ")";
        } else {
            txt = "  J Photo-Explorer Version " + AppInfo.getVersionString() + " of " + AppInfo.getBuildDate(false);
        }
        this.statusBar.setText(txt);
    }

    public void cut(List<AbstractFSObject> fsObjsToCut) {
        this.m_objsToPaste.clear();
        this.m_objsToPaste.addAll(fsObjsToCut);
        this.setStatusText();
        this.m_propertyPanel.refresh();
    }

    public boolean canPaste() {
        return this.m_objsToPaste != null && this.m_objsToPaste.size() > 0;
    }

    public void paste() {
        DirectoryObject oldParent = null;
        if (this.m_currentDir == null || this.m_objsToPaste.size() == 0) {
            return;
        }
        for (AbstractFSObject fsObj : this.m_objsToPaste) {
            if (fsObj instanceof DirectoryObject) {
                for (AbstractFSObject p = this.m_currentDir; p != null; p = p.getParent()) {
                    if (p != fsObj) continue;
                    JOptionPane.showMessageDialog(this, "Directory \"" + fsObj.getFileName() + "\" cannot be moved\ninto itself or one of its " + "subdirectories", "J Photo-Explorer", 2);
                    this.m_objsToPaste.clear();
                    this.setStatusText();
                    return;
                }
            }
            this.renameExportedFiles(fsObj, this.m_currentDir, null);
            oldParent = (DirectoryObject)fsObj.getParent();
            if (this.m_currentDir.addChild(fsObj, -1)) continue;
            JOptionPane.showMessageDialog(this, (fsObj instanceof FileObject ? "File \"" : "Directory \"") + fsObj.getFileName() + "\" cannot be moved.\n\nIt may be used by another " + "application.", "J Photo-Explorer", 0);
            this.m_objsToPaste.clear();
            this.setStatusText();
            return;
        }
        try {
            if (oldParent != null) {
                this.m_seriesContainer.saveSeries(oldParent, true);
            }
            this.m_seriesContainer.saveSeries(this.m_currentDir, true);
        }
        catch (PersistException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), "J Photo-Explorer", 0);
        }
        if (oldParent != null) {
            this.m_dirTreePanel.refresh(this.m_currentDir);
        }
        this.m_dirContentsPanel.refresh();
        this.m_dirContentsPanel.selectCurrentFiles(false, this.m_objsToPaste);
        this.m_objsToPaste.clear();
        this.setStatusText();
    }

    public boolean showProperties(AbstractFSObject fsObj) {
        this.save();
        PropertiesDialog dlg = new PropertiesDialog(this.getImageHolder(), fsObj, null, this, true);
        return dlg.showDialog();
    }

    public void delete(List<AbstractFSObject> fileObjsToDelete) {
        AbstractFSObject fsObj2;
        if (this.m_currentDir == null || fileObjsToDelete.size() == 0) {
            return;
        }
        for (AbstractFSObject fsObj2 : fileObjsToDelete) {
            int res;
            if (fsObj2.isReference()) {
                boolean bIsSeparator;
                boolean bl = bIsSeparator = fsObj2 instanceof FileObject && ((FileObject)fsObj2).isSeparator();
                if (!bIsSeparator && (res = JOptionPane.showConfirmDialog(this, "Do you really want to delete reference \"" + fsObj2.getTitle(true) + "\"?", "J Photo-Explorer", 0, 3)) != 0) {
                    return;
                }
            } else {
                String endStr;
                String beginStr;
                if (fsObj2 instanceof DirectoryObject) {
                    beginStr = "Directory \"";
                    endStr = "\nand its contents will be destroyed";
                } else {
                    beginStr = "File \"";
                    endStr = "";
                }
                res = JOptionPane.showConfirmDialog(this, beginStr + fsObj2.getFileName() + "\" will be deleted permanently" + endStr + ".\n\n" + "Do you want to continue?", "J Photo-Explorer", 0, 3);
                if (res != 0) {
                    return;
                }
                try {
                    ExportFactory.getExport(this.m_settings, this.m_seriesContainer, this).deleteExportedFiles(fsObj2, 1);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (fsObj2 instanceof DirectoryObject) {
                    ((DirectoryObject)fsObj2).delete(true);
                } else {
                    this.m_imgHolder.deleteThumbnails(fsObj2);
                    File f = new File(fsObj2.getFullPath());
                    if (f.exists()) {
                        f.delete();
                    }
                    fsObj2.setFileName("", false);
                }
            }
            this.m_dirContentsPanel.removeFSObject(fsObj2);
        }
        fileObjsToDelete.clear();
        fsObj2 = this.m_dirContentsPanel.getPreviousFile();
        if (fsObj2 != null) {
            fileObjsToDelete.add(fsObj2);
        }
        this.m_dirContentsPanel.selectCurrentFiles(true, fileObjsToDelete);
        this.m_objsToPaste.clear();
        this.setStatusText();
    }

    private void addExportedFiles(DirectoryObject dirObj, List<FileObject> exportList) {
        Iterator<FileObject> fileIter = dirObj.getFileIterator();
        while (fileIter.hasNext()) {
            FileObject fileObj = fileIter.next();
            if (fileObj.isReference() || !fileObj.isToExport()) continue;
            exportList.add(fileObj);
        }
        Iterator<DirectoryObject> dirIter = dirObj.getSubDirIterator();
        while (dirIter.hasNext()) {
            this.addExportedFiles(dirIter.next(), exportList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startExport(AbstractFSObject fsObj, boolean bMain, boolean bIndex, boolean bForce) {
        if (!this.m_exportReady.booleanValue() || this.m_exportTimer != null) {
            JOptionPane.showMessageDialog(this, "There is a Web export operation in progress. Please try later", "J Photo-Explorer", 2);
            return;
        }
        this.m_imgHolder.stopBackgroundImageLoading();
        this.save();
        this.setCursor(new Cursor(3));
        ArrayList<FileObject> exportList = new ArrayList<FileObject>(100);
        try {
            if (fsObj instanceof FileObject) {
                this.m_seriesContainer.saveSeriesForWeb((DirectoryObject)fsObj.getParent());
                if (!fsObj.isReference() && fsObj.isToExport()) {
                    this.m_seriesContainer.saveSeriesForWeb((DirectoryObject)fsObj.getParent());
                    exportList.add((FileObject)fsObj);
                }
            } else if (fsObj instanceof DirectoryObject) {
                DirectoryObject dirObj = (DirectoryObject)fsObj;
                if (dirObj.getParent() == null) {
                    this.m_seriesContainer.ensureLoaded(dirObj);
                }
                this.m_seriesContainer.saveSeriesForWeb(dirObj);
                this.addExportedFiles(dirObj, exportList);
            } else if (fsObj == null) {
                DirectoryObject[] series = this.m_seriesContainer.getSeriesDirectories();
                for (int i = 0; i < series.length; ++i) {
                    this.m_seriesContainer.ensureLoaded(series[i]);
                    this.m_seriesContainer.saveSeriesForWeb(series[i]);
                    this.addExportedFiles(series[i], exportList);
                }
            }
        }
        catch (PersistException pe) {
            JOptionPane.showMessageDialog(this, "Cannot export the series metadata to the Web export directory:\n" + pe.getMessage(), "J Photo-Explorer", 0);
            return;
        }
        finally {
            this.setCursor(new Cursor(0));
        }
        if (exportList.size() == 0) {
            JOptionPane.showMessageDialog(this, "There are no files to export", "J Photo-Explorer", 1);
            return;
        }
        ExportProgressDialog dlg = new ExportProgressDialog(this, ExportFactory.getExport(this.m_settings, this.m_seriesContainer, this).getDescription(), exportList.size());
        dlg.setVisible(true);
        this.m_exportProgress = null;
        this.m_exportError = null;
        this.m_exportStop = false;
        this.setCursor(new Cursor(3));
        ExportThread exThread = new ExportThread(exportList, this.m_settings, this.m_seriesContainer, this);
        exThread.setExportOptions(bMain, bIndex, bForce);
        exThread.start();
        this.m_exportTimer = new Timer(100, new ExportTimerTask(this, dlg));
        this.m_exportTimer.start();
    }

    public void stopExport() {
        this.m_exportStop = true;
        this.onExportReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSetReady(boolean state) {
        Boolean bl = this.m_exportReady;
        synchronized (bl) {
            this.m_exportReady = new Boolean(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSetError(String err) {
        Boolean bl = this.m_exportReady;
        synchronized (bl) {
            this.m_exportReady = new Boolean(true);
            this.m_exportError = err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportProgress getExportProgress() {
        Boolean bl = this.m_exportReady;
        synchronized (bl) {
            return this.m_exportProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExportProgress(ExportProgress p) {
        Boolean bl = this.m_exportReady;
        synchronized (bl) {
            this.m_exportProgress = p;
        }
    }

    public void onExportReady() {
        this.m_propertyPanel.refresh();
    }

    public void renameExportedFiles(AbstractFSObject oldFsObj, DirectoryObject newParent, String newName) {
        try {
            ExportFactory.getExport(this.m_settings, this.m_seriesContainer, this).renameExportedFiles(oldFsObj, newParent, newName);
            if (oldFsObj instanceof FileObject) {
                this.m_imgHolder.renameThumbnails(oldFsObj, newName);
            } else {
                this.m_imgHolder.moveThumbnailDirUnder((DirectoryObject)oldFsObj, newParent);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public DirectoryObject selectDirForPath(TreePath treePath, boolean bExact) {
        return this.m_dirTreePanel.selectDirForPath(treePath, bExact);
    }

    public void refresh() {
        this.save();
        this.m_objsToPaste.clear();
        this.m_currentDir = null;
        this.setStatusText();
        try {
            this.m_seriesContainer.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_dirTreePanel.refresh();
        this.m_dirContentsPanel.refresh();
        this.m_propertyPanel.refresh();
    }

    public void reloadSettings() {
        this.m_dirTreePanel.loadSettings(this.m_settings);
        this.m_propertyPanel.loadSettings(this.m_settings);
        this.m_dirContentsPanel.loadSettings(this.m_settings);
    }

    public void saveSettings() {
        this.m_dirTreePanel.saveSettings(this.m_settings);
        this.m_propertyPanel.saveSettings(this.m_settings);
        this.m_dirContentsPanel.saveSettings(this.m_settings);
    }

    public void save() {
        if (this.m_currentDir == null) {
            return;
        }
        this.m_dirTreePanel.saveChanges();
        this.m_propertyPanel.saveChanges();
        this.m_dirContentsPanel.saveChanges();
        try {
            this.m_seriesContainer.saveSeries(this.m_currentDir, false);
        }
        catch (PersistException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), "J Photo-Explorer", 0);
        }
    }

    public void exit() {
        boolean bIsMaximized;
        this.save();
        this.m_dirTreePanel.saveSettings(this.m_settings);
        this.m_propertyPanel.saveSettings(this.m_settings);
        this.m_dirContentsPanel.saveSettings(this.m_settings);
        boolean bl = bIsMaximized = (this.getState() & 6) == 6;
        if (bIsMaximized) {
            this.setState(0);
        }
        this.m_settings.setRect(MAIN_WIN_POS, this.getBounds());
        this.m_settings.setBoolean(MAIN_WIN_MAXIMIZED, bIsMaximized);
        this.m_settings.setInt(MAIN_WIN_DIR_SPLIT_POS, this.dirSplitPane.getDividerLocation());
        this.m_settings.setInt(MAIN_WIN_PROP_SPLIT_POS, this.propSplitPane.getDividerLocation());
        this.m_settings.save();
        System.exit(0);
    }

    private void initComponents() {
        this.dirSplitPane = new JSplitPane();
        this.propSplitPane = new JSplitPane();
        this.dirPanel = new JPanel();
        this.propertyPanel = new JPanel();
        this.contentsPanel = new JPanel();
        this.statusBar = new JLabel();
        this.menuBar = new JMenuBar();
        this.seriesMenu = new JMenu();
        this.prefsMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exportMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.refreshMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("J Photo-Explorer");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                ExplorerMainFrame.this.formWindowActivated(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                ExplorerMainFrame.this.exitForm(evt);
            }

            @Override
            public void windowDeactivated(WindowEvent evt) {
                ExplorerMainFrame.this.formWindowDeactivated(evt);
            }
        });
        this.dirSplitPane.setDividerLocation(300);
        this.propSplitPane.setDividerLocation(400);
        this.propSplitPane.setOrientation(0);
        this.dirPanel.setLayout(new BorderLayout());
        this.propSplitPane.setLeftComponent(this.dirPanel);
        this.propertyPanel.setLayout(new BorderLayout());
        this.propertyPanel.setMinimumSize(new Dimension(40, 40));
        this.propertyPanel.setOpaque(false);
        this.propertyPanel.setPreferredSize(new Dimension(100, 100));
        this.propSplitPane.setRightComponent(this.propertyPanel);
        this.dirSplitPane.setLeftComponent(this.propSplitPane);
        this.contentsPanel.setLayout(new BorderLayout(0, 6));
        this.contentsPanel.setMinimumSize(new Dimension(200, 224));
        this.dirSplitPane.setRightComponent(this.contentsPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        this.getContentPane().add((Component)this.dirSplitPane, gridBagConstraints);
        this.statusBar.setText("JPhoto-Explorer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(2, 2, 4, 2);
        this.getContentPane().add((Component)this.statusBar, gridBagConstraints);
        this.seriesMenu.setText("Series");
        this.prefsMenuItem.setText("Preferences");
        this.prefsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplorerMainFrame.this.prefsMenuItemActionPerformed(evt);
            }
        });
        this.seriesMenu.add(this.prefsMenuItem);
        this.jSeparator1.setForeground(new Color(153, 153, 153));
        this.seriesMenu.add(this.jSeparator1);
        this.exportMenuItem.setText("Export ...");
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplorerMainFrame.this.exportMenuItemActionPerformed(evt);
            }
        });
        this.seriesMenu.add(this.exportMenuItem);
        this.jSeparator2.setForeground(new Color(153, 153, 153));
        this.seriesMenu.add(this.jSeparator2);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplorerMainFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.seriesMenu.add(this.exitMenuItem);
        this.menuBar.add(this.seriesMenu);
        this.viewMenu.setText("View");
        this.refreshMenuItem.setText("Refresh");
        this.refreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplorerMainFrame.this.refreshMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.refreshMenuItem);
        this.menuBar.add(this.viewMenu);
        this.helpMenu.setText("Help");
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void formWindowDeactivated(WindowEvent evt) {
        this.m_dirTreePanel.setInactiveColors();
        this.m_propertyPanel.setInactiveColors();
        this.m_dirContentsPanel.setInactiveColors();
    }

    private void formWindowActivated(WindowEvent evt) {
        this.m_dirTreePanel.setActiveColors();
        this.m_propertyPanel.setActiveColors();
        this.m_dirContentsPanel.setActiveColors();
    }

    private void exportMenuItemActionPerformed(ActionEvent evt) {
        String s = this.m_settings.get("export.dir");
        if (s.length() == 0) {
            JOptionPane.showMessageDialog(this, "Please specify the Web export directory in the Series->Options dialog", "J Photo-Explorer", 0);
            return;
        }
        ExportSelDialog dlg = new ExportSelDialog((Frame)this, this.m_seriesContainer, this.m_settings, true);
        if (!dlg.showDialog()) {
            return;
        }
        DirectoryObject group = dlg.getGroup();
        this.startExport(group != null ? group : dlg.getSeries(), dlg.getExportMain(), dlg.getExportIndex(), dlg.getForceExport());
    }

    private void refreshMenuItemActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void prefsMenuItemActionPerformed(ActionEvent evt) {
        this.save();
        SettingsDialog dlg = new SettingsDialog(this, this.m_seriesContainer, this.m_settings, true);
        if (!dlg.showDialog()) {
            return;
        }
        this.refresh();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        AboutDialog dlg = new AboutDialog((Frame)this, true);
        dlg.setVisible(true);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.exit();
    }

    private void exitForm(WindowEvent evt) {
        this.exit();
    }
}

