/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.ui.ToLoadItem;
import com.dgrossmann.photo.webexport.ImageMagickExporter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import magick.MagickImage;

public class ImageHolder
implements Runnable {
    public static final String SC_PROPERTIES = "prop";
    private static final String TN_DIR_NAME = "_JP_Preview";
    private boolean m_bImgLoaded = false;
    private ImageIcon m_imgImg = null;
    private ImageIcon m_imgHTML = null;
    private ImageIcon m_imgXML = null;
    private ImageIcon m_imgPDF = null;
    private ImageIcon m_imgMsWord = null;
    private ImageIcon m_imgMsVisio = null;
    private ImageIcon m_imgText = null;
    private ImageIcon m_imgCAD = null;
    private ImageIcon m_imgZIP = null;
    private ImageIcon m_imgRef = null;
    private ImageIcon m_imgHTMLRef = null;
    private ImageIcon m_imgDir = null;
    private ImageIcon m_imgSep = null;
    private ImageIcon m_imgImgPrev = null;
    private ImageIcon m_imgOther = null;
    private String m_lastError = "";
    private Map<String, Map<String, ImageIcon>> m_imageCats = new HashMap<String, Map<String, ImageIcon>>(5);
    private List<String> m_transientCats = new ArrayList<String>();
    private List<ToLoadItem> m_toLoad = new ArrayList<ToLoadItem>(10);
    private Thread m_loadThread = null;
    private Boolean m_bHasNewImages = new Boolean(false);
    private static final int THOP_RENAME = 1;
    private static final int THOP_DELETE = 2;

    public String getLastError() {
        String retStr = this.m_lastError;
        this.m_lastError = "";
        return retStr;
    }

    public static ImageIcon loadStandardImage(String name, Component parent) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL imgURL = ClassLoader.getSystemResource(name);
        if (imgURL == null) {
            return null;
        }
        MediaTracker track = new MediaTracker(parent);
        Image img = tk.getImage(imgURL);
        track.addImage(img, 0);
        try {
            track.waitForAll();
        }
        catch (InterruptedException iexc) {
            // empty catch block
        }
        return new ImageIcon(img);
    }

    public void addTransientScaleCategory(String scaleCategory) {
        if (!this.m_transientCats.contains(scaleCategory)) {
            this.m_transientCats.add(scaleCategory);
        }
    }

    public void thumbnailsOp(AbstractFSObject fsObj, String newName, int op) {
        int index;
        if (!(fsObj instanceof FileObject)) {
            return;
        }
        FileObject fileObj = (FileObject)fsObj;
        int fileType = fileObj.getFileType();
        if (fileType != 1 && fileType != 2) {
            return;
        }
        String imgFilePath = fileObj.getFullPath();
        File parentDir = this.getThumbnailDirectory(fileObj);
        if (parentDir == null) {
            return;
        }
        String oldBaseName = fileObj.getBaseFileName();
        String newBaseName = "";
        if (op == 1) {
            index = newName.lastIndexOf(".");
            newBaseName = index > 0 ? newName.substring(0, index) : newName;
        }
        String namePattern = "^_" + oldBaseName + "_[A-Za-z0-9]+\\.png$";
        String[] dirContents = parentDir.list();
        if (dirContents != null) {
            block4: for (int i = 0; i < dirContents.length; ++i) {
                File f;
                if (!dirContents[i].matches(namePattern) || !(f = new File(parentDir, dirContents[i])).isFile()) continue;
                switch (op) {
                    case 1: {
                        index = dirContents[i].lastIndexOf("_");
                        File newFile = new File(parentDir, "_" + newBaseName + dirContents[i].substring(index));
                        if (f.renameTo(newFile)) continue block4;
                        System.err.println("W: Cannot rename thumbnail file from:\n   " + f.getAbsolutePath() + "\nto:\n   " + newFile.getAbsolutePath());
                        continue block4;
                    }
                    case 2: {
                        if (f.delete()) continue block4;
                        System.err.println("W: Cannot delete thumbnail file " + f);
                    }
                }
            }
        }
        if (this.m_imageCats == null) {
            return;
        }
        for (Map<String, ImageIcon> imageMap : this.m_imageCats.values()) {
            imageMap.remove(imgFilePath);
        }
    }

    public void renameThumbnails(AbstractFSObject fsObj, String newName) {
        this.thumbnailsOp(fsObj, newName, 1);
    }

    public void deleteThumbnails(AbstractFSObject fsObj) {
        this.thumbnailsOp(fsObj, null, 2);
    }

    public boolean moveThumbnailDirUnder(DirectoryObject dirObj, DirectoryObject newParentObj) {
        File oldDir = this.getThumbnailDirectory(dirObj);
        File newParentDir = this.getThumbnailDirectory(newParentObj);
        if (oldDir == null || newParentDir == null) {
            return false;
        }
        if (oldDir.renameTo(new File(newParentDir, dirObj.getFileName()))) {
            return false;
        }
        this.m_imageCats.clear();
        this.m_imageCats = new HashMap<String, Map<String, ImageIcon>>(5);
        return true;
    }

    private File getThumbnailDirectory(AbstractFSObject fsObj) {
        ArrayList<String> parents = new ArrayList<String>(10);
        DirectoryObject seriesDir = fsObj instanceof DirectoryObject ? (DirectoryObject)fsObj : (DirectoryObject)fsObj.getParent();
        if (seriesDir == null) {
            return null;
        }
        while (seriesDir.getParent() != null) {
            parents.add(0, seriesDir.getFileName());
            seriesDir = (DirectoryObject)seriesDir.getParent();
        }
        File tnDir = new File(seriesDir.getFullPath() + File.separator + ".." + File.separator + TN_DIR_NAME);
        if (!tnDir.isDirectory() && !tnDir.mkdir()) {
            return null;
        }
        if (!(tnDir = new File(tnDir, seriesDir.getFileName().toLowerCase())).isDirectory() && !tnDir.mkdir()) {
            return null;
        }
        Iterator iter = parents.iterator();
        while (iter.hasNext()) {
            if ((tnDir = new File(tnDir, (String)iter.next())).isDirectory() || tnDir.mkdir()) continue;
            return null;
        }
        return tnDir;
    }

    private File getThumbnailFile(FileObject fileObj, String scaleCategory) {
        File tnDir = this.getThumbnailDirectory(fileObj);
        if (tnDir == null) {
            return null;
        }
        File tnFile = new File(tnDir, '_' + fileObj.getBaseFileName() + '_' + scaleCategory + ".png");
        return tnFile;
    }

    private ImageIcon readScaledImage(FileObject fileObj, String scaleCategory, int imgSize, Component parent) {
        Image scaledImg2;
        int newHeight;
        int newWidth;
        int imgHeight;
        File thumbNail;
        this.m_lastError = "";
        Map<String, ImageIcon> imageMap = this.m_imageCats.get(scaleCategory);
        String imgFilePath = fileObj.getFullPath();
        BufferedImage img = null;
        try {
            ImageMagickExporter ex = new ImageMagickExporter();
            thumbNail = this.getThumbnailFile(fileObj, scaleCategory);
            if (ex.isAvailable() && thumbNail != null) {
                int newHeight2;
                int newWidth2;
                MagickImage origMImage = ex.readImage(imgFilePath);
                Dimension siz = origMImage.getDimension();
                if (siz.width > siz.height) {
                    newWidth2 = imgSize;
                    newHeight2 = siz.height * newWidth2 / siz.width;
                } else {
                    newHeight2 = imgSize;
                    newWidth2 = siz.width * newHeight2 / siz.height;
                }
                ex.writeScaledImage(origMImage, new Dimension(newWidth2, newHeight2), thumbNail.getAbsolutePath());
                origMImage = null;
                Runtime.getRuntime().gc();
                img = ImageIO.read(thumbNail);
                ImageIcon imgIcon = new ImageIcon(img);
                imageMap.put(imgFilePath, imgIcon);
                return imgIcon;
            }
        }
        catch (Exception e) {
            System.err.println("W: Exception while reading image for:\n" + imgFilePath + "\n" + e);
            e.printStackTrace();
        }
        try {
            img = ImageIO.read(new File(imgFilePath));
        }
        catch (OutOfMemoryError me) {
            thumbNail = null;
            img = null;
            Runtime.getRuntime().gc();
            imageMap.clear();
            Runtime.getRuntime().gc();
            this.m_lastError = "Out of memory while reading image:\n" + imgFilePath;
            System.err.println("E: " + this.m_lastError);
            return null;
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (img == null) {
            return null;
        }
        if (imgSize <= 0) {
            ImageIcon imgIcon = new ImageIcon(img);
            imageMap.put(imgFilePath, imgIcon);
            return imgIcon;
        }
        int imgWidth = img.getWidth(null);
        if (imgWidth > (imgHeight = img.getHeight(null))) {
            newWidth = imgSize;
            newHeight = imgHeight * newWidth / imgWidth;
        } else {
            newHeight = imgSize;
            newWidth = imgWidth * newHeight / imgHeight;
        }
        try {
            scaledImg2 = img.getScaledInstance(newWidth, newHeight, 16);
            MediaTracker track = new MediaTracker(parent);
            track.addImage(scaledImg2, 0);
            try {
                track.waitForAll();
            }
            catch (InterruptedException iexc) {}
        }
        catch (OutOfMemoryError me1) {
            thumbNail = null;
            img = null;
            Object scaledImg2 = null;
            Runtime.getRuntime().gc();
            imageMap.clear();
            Runtime.getRuntime().gc();
            this.m_lastError = "Out of memory while scaling image:\n" + imgFilePath;
            System.err.println("E: " + this.m_lastError);
            return null;
        }
        thumbNail = this.getThumbnailFile(fileObj, scaleCategory);
        if (thumbNail != null) {
            try {
                BufferedImage scaledBufImg;
                Graphics2D gr;
                boolean bReady;
                int imgType = img.getType();
                if (imgType <= 0) {
                    imgType = 2;
                }
                if (!(bReady = (gr = (scaledBufImg = new BufferedImage(newWidth, newHeight, imgType)).createGraphics()).drawImage(scaledImg2, 0, 0, null))) {
                    try {
                        Thread.sleep(55L);
                    }
                    catch (Exception sleepEx) {
                        // empty catch block
                    }
                }
                ImageIO.write((RenderedImage)scaledBufImg, "png", thumbNail);
                scaledBufImg.flush();
                scaledBufImg = null;
            }
            catch (Exception exc) {
                this.m_lastError = "While writing thumbnail \"" + thumbNail + "\"\nException: " + exc;
                System.err.println("E: " + this.m_lastError);
            }
        }
        img.flush();
        img = null;
        Runtime.getRuntime().gc();
        ImageIcon imgIcon = new ImageIcon(scaledImg2);
        imageMap.put(imgFilePath, imgIcon);
        return imgIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLoad(FileObject fileObj, String scaleCategory, int imgSize, Component parent) {
        List<ToLoadItem> list = this.m_toLoad;
        synchronized (list) {
            for (ToLoadItem item : this.m_toLoad) {
                if (item.fileObj != fileObj || !item.scaleCategory.equals(scaleCategory)) continue;
                return;
            }
            this.m_toLoad.add(new ToLoadItem(fileObj, scaleCategory, imgSize, parent));
        }
        if (this.m_loadThread == null) {
            this.m_loadThread = new Thread(this);
            this.m_loadThread.setPriority(1);
            this.m_loadThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNewImages() {
        Boolean bl = this.m_bHasNewImages;
        synchronized (bl) {
            return this.m_bHasNewImages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAllImages() {
        boolean bHasAll;
        boolean bl = bHasAll = this.m_loadThread == null;
        if (bHasAll) {
            Boolean bl2 = this.m_bHasNewImages;
            synchronized (bl2) {
                this.m_bHasNewImages = new Boolean(false);
            }
        }
        return bHasAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBackgroundImageLoading() {
        Object object = this.m_toLoad;
        synchronized (object) {
            this.m_toLoad.clear();
        }
        object = this.m_bHasNewImages;
        synchronized (object) {
            this.m_bHasNewImages = new Boolean(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int outOfMemoryCount = 0;
        int sleepInterval = 2222;
        ToLoadItem item = null;
        while (true) {
            ImageIcon image;
            Object object;
            if (item == null) {
                object = this.m_toLoad;
                synchronized (object) {
                    if (this.m_toLoad.size() == 0) {
                        break;
                    }
                    item = this.m_toLoad.remove(0);
                    outOfMemoryCount = 0;
                    sleepInterval = 2222;
                }
            } else if (outOfMemoryCount > 5) {
                object = this.m_toLoad;
                synchronized (object) {
                    System.err.println("E: Too many out-of-memory errors");
                    this.m_toLoad.clear();
                    break;
                }
            }
            try {
                image = this.readScaledImage(item.fileObj, item.scaleCategory, item.imgSize, item.parent);
            }
            catch (OutOfMemoryError me) {
                image = null;
            }
            catch (Exception exc) {
                image = null;
            }
            if (image == null) {
                ++outOfMemoryCount;
                try {
                    Runtime.getRuntime().gc();
                    Thread.sleep(sleepInterval += outOfMemoryCount * 777);
                    Runtime.getRuntime().gc();
                }
                catch (InterruptedException ie) {}
                continue;
            }
            item = null;
            object = this.m_bHasNewImages;
            synchronized (object) {
                this.m_bHasNewImages = new Boolean(true);
            }
        }
        this.m_loadThread = null;
    }

    private ImageIcon loadImage(FileObject fileObj, String scaleCategory, int imgSize, Component parent, boolean bWaitForImage) {
        String imgFilePath;
        ImageIcon imgObj;
        this.m_lastError = "";
        Map<String, ImageIcon> imageMap = this.m_imageCats.get(scaleCategory);
        if (imageMap == null) {
            imageMap = new HashMap<String, ImageIcon>(300);
            this.m_imageCats.put(scaleCategory, imageMap);
        }
        if ((imgObj = imageMap.get(imgFilePath = fileObj.getFullPath())) != null && imgObj instanceof ImageIcon) {
            return imgObj;
        }
        if (this.m_transientCats.contains(scaleCategory) && imageMap.size() > 600) {
            imageMap.clear();
        }
        BufferedImage img = null;
        File thumbNail = this.getThumbnailFile(fileObj, scaleCategory);
        if (thumbNail != null && thumbNail.isFile()) {
            try {
                long imgTime = new File(imgFilePath).lastModified();
                long tnTime = thumbNail.lastModified();
                if (tnTime >= imgTime) {
                    img = ImageIO.read(thumbNail);
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            if (img != null) {
                ImageIcon imgIcon = new ImageIcon(img);
                imageMap.put(imgFilePath, imgIcon);
                return imgIcon;
            }
        }
        if (bWaitForImage) {
            return this.readScaledImage(fileObj, scaleCategory, imgSize, parent);
        }
        this.addToLoad(fileObj, scaleCategory, imgSize, parent);
        return null;
    }

    public ImageIcon getTypeImage(AbstractFSObject fsObj, boolean bWithImagePreview, String scaleCategory, int imgSize, Component parent, boolean bWaitForImage) {
        if (!this.m_bImgLoaded) {
            this.m_imgImg = ImageHolder.loadStandardImage("images/type-img.gif", parent);
            this.m_imgImgPrev = ImageHolder.loadStandardImage("images/type-img-preview.gif", parent);
            this.m_imgHTML = ImageHolder.loadStandardImage("images/type-html.gif", parent);
            this.m_imgXML = ImageHolder.loadStandardImage("images/type-xml.gif", parent);
            this.m_imgText = ImageHolder.loadStandardImage("images/type-text.gif", parent);
            this.m_imgCAD = ImageHolder.loadStandardImage("images/type-cad.gif", parent);
            this.m_imgZIP = ImageHolder.loadStandardImage("images/type-zip.gif", parent);
            this.m_imgPDF = ImageHolder.loadStandardImage("images/type-pdf.gif", parent);
            this.m_imgMsWord = ImageHolder.loadStandardImage("images/type-msword.gif", parent);
            this.m_imgMsVisio = ImageHolder.loadStandardImage("images/type-msvisio.gif", parent);
            this.m_imgRef = ImageHolder.loadStandardImage("images/type-ref.gif", parent);
            this.m_imgHTMLRef = ImageHolder.loadStandardImage("images/type-html-ref.gif", parent);
            this.m_imgDir = ImageHolder.loadStandardImage("images/type-dir.gif", parent);
            this.m_imgSep = ImageHolder.loadStandardImage("images/type-sep.gif", parent);
            this.m_imgOther = ImageHolder.loadStandardImage("images/type-other.gif", parent);
            this.m_bImgLoaded = true;
        }
        if (fsObj instanceof FileObject) {
            switch (((FileObject)fsObj).getFileType()) {
                case 1: {
                    ImageIcon imgIcon;
                    if (bWithImagePreview && (imgIcon = this.loadImage((FileObject)fsObj, scaleCategory, imgSize, parent, bWaitForImage)) != null) {
                        return imgIcon;
                    }
                    return this.m_imgImgPrev;
                }
                case 2: {
                    return this.m_imgImg;
                }
                case 3: {
                    return this.m_imgHTML;
                }
                case 4: {
                    return this.m_imgXML;
                }
                case 5: {
                    return this.m_imgPDF;
                }
                case 6: {
                    return this.m_imgMsWord;
                }
                case 7: {
                    return this.m_imgMsVisio;
                }
                case 8: {
                    return this.m_imgText;
                }
                case 9: {
                    return this.m_imgCAD;
                }
                case 10: {
                    return this.m_imgZIP;
                }
                case 11: {
                    return this.m_imgRef;
                }
                case 12: {
                    return this.m_imgHTMLRef;
                }
                case 13: {
                    return this.m_imgSep;
                }
            }
        } else if (fsObj instanceof DirectoryObject) {
            return this.m_imgDir;
        }
        return this.m_imgOther;
    }
}

