/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui;

import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.ui.dialog.HtmlViewDialog;
import com.dgrossmann.photo.ui.dialog.ImageViewDialog;
import com.dgrossmann.photo.ui.dialog.TextViewDialog;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JOptionPane;

public class ShellExec {
    private Frame m_parentFrame;
    private Dialog m_parentDialog;

    public ShellExec(Frame parentFrame) {
        this.m_parentFrame = parentFrame;
        this.m_parentDialog = null;
    }

    public ShellExec(Dialog parentDialog) {
        this.m_parentFrame = null;
        this.m_parentDialog = parentDialog;
    }

    public void openDocument(FileObject fileObj) {
        String title = fileObj.getTitlePlain();
        String path = fileObj.isReference() ? fileObj.get("href") : fileObj.getFullPath();
        switch (fileObj.getFileType()) {
            case 1: {
                ImageViewDialog imgDlg = this.m_parentFrame != null ? new ImageViewDialog(fileObj, this.m_parentFrame, false) : new ImageViewDialog(fileObj, this.m_parentDialog, false);
                imgDlg.setVisible(true);
                break;
            }
            case 3: 
            case 12: {
                HtmlViewDialog htmlDlg = this.m_parentFrame != null ? new HtmlViewDialog(this.m_parentFrame, title, path, false) : new HtmlViewDialog(this.m_parentDialog, title, path, false);
                htmlDlg.setVisible(true);
                break;
            }
            case 4: 
            case 8: {
                TextViewDialog textDlg = this.m_parentFrame != null ? new TextViewDialog(this.m_parentFrame, title, path, false) : new TextViewDialog(this.m_parentDialog, title, path, false);
                textDlg.setVisible(true);
                break;
            }
            default: {
                try {
                    Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", fileObj.getFullPath()});
                    break;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Cannot open file \"" + fileObj.getFullPath() + "\"\nException: " + e, "J Photo-Explorer", 0);
                }
            }
        }
    }
}

