/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.ui.ImageHolder;
import com.dgrossmann.photo.ui.dialog.AssocTableMouseListener;
import com.dgrossmann.photo.ui.dialog.AssociateFileTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AssociateDialog
extends JDialog {
    private static int SZ_MODIFIED_WIDTH_S = 110;
    private static int SZ_MODIFIED_WIDTH_L = 128;
    private ImageHolder m_imgHolder;
    private FileObject m_currentFile;
    private boolean m_isChanged;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel desc2Label;
    private JLabel descLabel;
    private JScrollPane listScrollPane;
    private JTable listTable;
    private JButton okButton;
    private JLabel titleLabel;

    public AssociateDialog(Frame parent, ImageHolder imgHolder, FileObject currentFile, boolean modal) {
        super(parent, modal);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        this.m_imgHolder = imgHolder;
        this.m_currentFile = currentFile;
        this.m_isChanged = false;
        this.initComponents();
        this.listTable.setShowHorizontalLines(true);
        this.listTable.setGridColor(new Color(222, 222, 211));
        AssociateFileTableModel tModel = (AssociateFileTableModel)this.listTable.getModel();
        tModel.setCurrentDir((DirectoryObject)this.m_currentFile.getParent());
        if (tModel.getRowCount() == 0) {
            this.okButton.setEnabled(false);
        }
        JTableHeader thead = this.listTable.getTableHeader();
        Dimension thSize = thead.getPreferredSize();
        if (thSize.height < 18) {
            thSize.height = 18;
        }
        thead.setPreferredSize(thSize);
        this.listTable.setRowHeight(34);
        this.listTable.addMouseListener(new AssocTableMouseListener(this));
        TableColumnModel cModel = this.listTable.getColumnModel();
        TableColumn col = cModel.getColumn(0);
        col.setPreferredWidth(32);
        col.setWidth(32);
        col.setMinWidth(32);
        col.setMaxWidth(32);
        col.setResizable(false);
        col = cModel.getColumn(1);
        col.setPreferredWidth(180);
        col.setWidth(180);
        col.setMinWidth(20);
        col.setMaxWidth(1000);
        int colWidth = screenSize.width > 1200 ? SZ_MODIFIED_WIDTH_L : SZ_MODIFIED_WIDTH_S;
        col = cModel.getColumn(3);
        col.setPreferredWidth(colWidth);
        col.setWidth(colWidth);
        col.setMinWidth(50);
        col.setMaxWidth(200);
        this.titleLabel.setText("This dialog associates the reference \"" + this.m_currentFile.getTitle(true) + "\" with a file in the same directory.");
        String str = this.m_currentFile.getTitle(true);
        if (str.length() > 0) {
            str = str + " - " + this.getTitle();
            this.setTitle(str);
        }
        Rectangle parentRect = parent.getBounds();
        Rectangle thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0) {
            thisRect.x = 0;
        }
        if (thisRect.y < 0) {
            thisRect.y = 0;
        }
        this.setBounds(thisRect);
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.m_isChanged;
    }

    public void invokeOkButtonAction() {
        this.okButtonActionPerformed(null);
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.descLabel = new JLabel();
        this.desc2Label = new JLabel();
        this.listScrollPane = new JScrollPane();
        this.listTable = new JTable();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Associate Reference with File");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AssociateDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setText(" ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.titleLabel, gridBagConstraints);
        this.descLabel.setText("The data from the reference are merged with those of the file, and the reference is deleted afterwards. ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.getContentPane().add((Component)this.descLabel, gridBagConstraints);
        this.desc2Label.setText("Please select the file to associate the reference with from the following list:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.desc2Label, gridBagConstraints);
        this.listTable.setModel(new AssociateFileTableModel(this, this.m_imgHolder));
        this.listTable.setShowHorizontalLines(false);
        this.listTable.setShowVerticalLines(false);
        this.listScrollPane.setViewportView(this.listTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.listScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociateDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociateDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        FileObject toAssoc = null;
        int index = this.listTable.getSelectedRow();
        if (index >= 0) {
            AssociateFileTableModel tModel = (AssociateFileTableModel)this.listTable.getModel();
            toAssoc = tModel.getFileAt(index);
        }
        if (toAssoc == null) {
            JOptionPane.showMessageDialog(this, "Please select the file you wish to associate reference \"" + this.m_currentFile.getTitle(true) + "\"\nwith from the file list.", "J Photo-Explorer", 2);
            return;
        }
        String sRef = this.m_currentFile.getTitle(false);
        if (sRef.length() > 0) {
            toAssoc.set("title", sRef);
        }
        if ((sRef = this.m_currentFile.get("subtitle")).length() > 0) {
            toAssoc.set("subtitle", sRef);
        }
        if ((sRef = this.m_currentFile.get("href")).length() > 0) {
            toAssoc.set("href", sRef);
        }
        sRef = this.m_currentFile.get("description");
        String sFile = toAssoc.get("description");
        if (sRef.length() > 0) {
            if (sFile.length() > 0) {
                sRef = sRef + "\n\n" + sFile;
            }
            toAssoc.set("description", sRef);
        }
        if ((sRef = this.m_currentFile.get("remark")).length() > 0) {
            toAssoc.set("remark", sRef);
        }
        ((DirectoryObject)toAssoc.getParent()).removeFile(this.m_currentFile);
        this.m_currentFile = null;
        this.m_isChanged = true;
        this.cancelButtonActionPerformed(evt);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

