/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.dir.SeriesContainer;
import com.dgrossmann.photo.settings.Settings;
import com.dgrossmann.photo.webexport.ExportFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class ExportedImageViewDialog
extends JDialog {
    private static final String EXPORTED_IMAGE_VIEW = "Exported Image View";
    private Settings m_settings;
    private SeriesContainer m_seriesContainer;
    private Color m_errorColor;
    private FileObject m_fileObj;
    private Image m_image;
    private ImageIcon m_imageIcon;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JLabel imageLabel;
    private JScrollPane jScrollPane1;
    private JButton nextImgButton;
    private JButton prevImgButton;
    private JLabel sepLabel;
    private JLabel sizeLabel;
    private JLabel titleLabel;

    public ExportedImageViewDialog(FileObject fileObj, Settings settings, SeriesContainer seriesContainer, Dialog parent, boolean modal) {
        super(parent, modal);
        this.initialize(fileObj, settings, seriesContainer);
    }

    public ExportedImageViewDialog(FileObject fileObj, Settings settings, SeriesContainer seriesContainer, Frame parent, boolean modal) {
        super(parent, modal);
        this.initialize(fileObj, settings, seriesContainer);
    }

    private void initialize(FileObject fileObj, Settings settings, SeriesContainer seriesContainer) {
        this.m_fileObj = fileObj;
        this.m_settings = settings;
        this.m_seriesContainer = seriesContainer;
        this.m_image = null;
        this.m_imageIcon = null;
        this.m_errorColor = new Color(153, 51, 51);
        this.initComponents();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.loadImage();
        Rectangle parentRect = this.getParent().getBounds();
        Rectangle thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0) {
            thisRect.x = 0;
        }
        if (thisRect.y < 0) {
            thisRect.y = 0;
        }
        this.setBounds(thisRect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage() {
        File[] exportedFiles;
        File f = null;
        this.enableNavButtons();
        if (this.m_fileObj != null && (exportedFiles = ExportFactory.getExport(this.m_settings, this.m_seriesContainer, this.getParent()).getExportedFiles(this.m_fileObj)) != null) {
            f = exportedFiles[0];
        }
        if (f == null) {
            this.imageLabel.setIcon(null);
            this.imageLabel.setText("No exported image");
            this.titleLabel.setText(" ");
            this.sizeLabel.setText(" ");
            this.setTitle(EXPORTED_IMAGE_VIEW);
            return;
        }
        String str = this.m_fileObj.getTitlePlain();
        if (str.length() > 0) {
            str = str + " - ";
        }
        str = str + EXPORTED_IMAGE_VIEW;
        this.setTitle(str);
        this.titleLabel.setText(this.m_fileObj.getTitlePlain());
        this.getParent().setCursor(new Cursor(3));
        str = " ";
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            MediaTracker track = new MediaTracker(this);
            this.m_image = tk.getImage(f.toURI().toURL());
            track.addImage(this.m_image, 0);
            try {
                track.waitForAll();
            }
            catch (InterruptedException iexc) {
                // empty catch block
            }
            this.m_imageIcon = new ImageIcon(this.m_image);
            if (this.m_imageIcon != null) {
                str = this.m_imageIcon.getIconWidth() + " x " + this.m_imageIcon.getIconHeight() + " pixels  (" + f.length() / 1024L + " KB)";
                this.imageLabel.setIcon(this.m_imageIcon);
                this.imageLabel.setPreferredSize(new Dimension(this.m_imageIcon.getIconWidth(), this.m_imageIcon.getIconHeight()));
            }
        }
        catch (OutOfMemoryError me) {
            this.m_image = null;
            this.m_imageIcon = null;
            Runtime.getRuntime().gc();
            str = "Out of memory while reading image - Please close the window.";
            this.sizeLabel.setForeground(this.m_errorColor);
        }
        catch (Exception e) {
            str = "Cannot load original image: " + e.getMessage();
            this.sizeLabel.setForeground(this.m_errorColor);
        }
        finally {
            this.getParent().setCursor(new Cursor(0));
            this.sizeLabel.setText(str);
        }
    }

    private void enableNavButtons() {
        boolean bHavePrevious = false;
        boolean bHaveNext = false;
        if (this.m_fileObj != null) {
            FileObject fileObj;
            int i;
            DirectoryObject dirObj = (DirectoryObject)this.m_fileObj.getParent();
            int index = dirObj.getIndexOfFile(this.m_fileObj);
            for (i = index - 1; i >= 0; --i) {
                fileObj = dirObj.getFileAt(i);
                if (!fileObj.isToExport() || fileObj.getFileType() != 1) continue;
                bHavePrevious = true;
                break;
            }
            for (i = index + 1; i < dirObj.getFileCount(); ++i) {
                fileObj = dirObj.getFileAt(i);
                if (!fileObj.isToExport() || fileObj.getFileType() != 1) continue;
                bHaveNext = true;
                break;
            }
        }
        this.prevImgButton.setEnabled(bHavePrevious);
        this.nextImgButton.setEnabled(bHaveNext);
    }

    private Dimension getDefaultSize() {
        int prefWidth = this.m_settings.getInt("export.mainimg.length", 600);
        int maxWidth = this.m_settings.getInt("export.mainimg.max_width", 700);
        int prefHeight = this.m_settings.getInt("export.mainimg.max_height", 450);
        JScrollBar tempSB = new JScrollBar();
        Dimension prefSBSize = tempSB.getUI().getPreferredSize(tempSB);
        int sbWidth = prefSBSize != null ? prefSBSize.width : 0;
        return new Dimension(Math.max(maxWidth, prefWidth) + sbWidth, Math.max(prefWidth, prefHeight) + sbWidth);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.imageLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.sizeLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.prevImgButton = new JButton();
        this.nextImgButton = new JButton();
        this.sepLabel = new JLabel();
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExportedImageViewDialog.this.closeDialog(evt);
            }
        });
        this.imageLabel.setMaximumSize(this.getDefaultSize());
        this.imageLabel.setPreferredSize(this.getDefaultSize());
        this.jScrollPane1.setViewportView(this.imageLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.titleLabel.setForeground(new Color(0, 70, 213));
        this.titleLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.getContentPane().add((Component)this.titleLabel, gridBagConstraints);
        this.sizeLabel.setText("3000 x 3000 pixels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.getContentPane().add((Component)this.sizeLabel, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.prevImgButton.setText("< Previous");
        this.prevImgButton.setToolTipText("Go to the previous exported image");
        this.prevImgButton.setMaximumSize(new Dimension(110, 28));
        this.prevImgButton.setMinimumSize(new Dimension(110, 28));
        this.prevImgButton.setPreferredSize(new Dimension(110, 28));
        this.prevImgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportedImageViewDialog.this.prevImgButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.prevImgButton);
        this.nextImgButton.setText("Next >");
        this.nextImgButton.setToolTipText("Go to the next exported image");
        this.nextImgButton.setMaximumSize(new Dimension(110, 28));
        this.nextImgButton.setMinimumSize(new Dimension(110, 28));
        this.nextImgButton.setPreferredSize(new Dimension(110, 28));
        this.nextImgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportedImageViewDialog.this.nextImgButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.nextImgButton);
        this.sepLabel.setText(" ");
        this.buttonPanel.add(this.sepLabel);
        this.closeButton.setText("Close");
        this.closeButton.setMaximumSize(new Dimension(110, 28));
        this.closeButton.setMinimumSize(new Dimension(110, 28));
        this.closeButton.setPreferredSize(new Dimension(110, 28));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportedImageViewDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void nextImgButtonActionPerformed(ActionEvent evt) {
        if (this.m_fileObj == null) {
            return;
        }
        DirectoryObject dirObj = (DirectoryObject)this.m_fileObj.getParent();
        int index = dirObj.getIndexOfFile(this.m_fileObj);
        for (int i = index + 1; i < dirObj.getFileCount(); ++i) {
            FileObject fileObj = dirObj.getFileAt(i);
            if (!fileObj.isToExport() || fileObj.getFileType() != 1) continue;
            this.m_fileObj = fileObj;
            this.loadImage();
            break;
        }
    }

    private void prevImgButtonActionPerformed(ActionEvent evt) {
        if (this.m_fileObj == null) {
            return;
        }
        DirectoryObject dirObj = (DirectoryObject)this.m_fileObj.getParent();
        int index = dirObj.getIndexOfFile(this.m_fileObj);
        for (int i = index - 1; i >= 0; --i) {
            FileObject fileObj = dirObj.getFileAt(i);
            if (!fileObj.isToExport() || fileObj.getFileType() != 1) continue;
            this.m_fileObj = fileObj;
            this.loadImage();
            break;
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

