/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HtmlViewDialog
extends JDialog
implements HyperlinkListener {
    private URL m_homeURL;
    private URL m_lastURL;
    private JLabel titleLabel;
    private JButton backButton;
    private JEditorPane editorPane;
    private JPanel buttonPanel;
    private JScrollPane jScrollPane1;
    private JButton homeButton;
    private JButton closeButton;

    public HtmlViewDialog(Frame parent, String title, String htmlFilePath, boolean modal) {
        super(parent, modal);
        this.initialize(title, htmlFilePath);
    }

    public HtmlViewDialog(Dialog parent, String title, String htmlFilePath, boolean modal) {
        super(parent, modal);
        this.initialize(title, htmlFilePath);
    }

    private void initialize(String title, String htmlFilePath) {
        String tit;
        this.initComponents();
        String string = tit = title != null ? title : " ";
        if (tit.length() > 1) {
            tit = tit + " - ";
        }
        tit = tit + "HTML View";
        this.setTitle(tit);
        this.titleLabel.setText(htmlFilePath);
        this.backButton.setEnabled(false);
        this.editorPane.addHyperlinkListener(this);
        this.m_lastURL = null;
        this.m_homeURL = null;
        try {
            this.m_homeURL = new URL("file:///" + htmlFilePath);
            this.editorPane.setPage(this.m_homeURL);
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, "Wrong file URL: " + e.toString(), "J Photo-Explorer", 0);
        }
        catch (IOException ioExc) {
            JOptionPane.showMessageDialog(this, "I/O Error: " + ioExc.toString(), "J Photo-Explorer", 0);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension siz = tk.getScreenSize();
        Rectangle frameRect = new Rectangle();
        frameRect.width = 950;
        if (frameRect.width >= siz.width) {
            frameRect.width = siz.width;
        }
        frameRect.height = siz.height - 34;
        frameRect.x = 0;
        frameRect.y = 0;
        this.setBounds(frameRect);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        this.backButton.setEnabled(true);
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            this.m_lastURL = pane.getPage();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    pane.setPage(e.getURL());
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(this, "Cannot find URL:\n" + e.getURL(), "J Photo-Explorer", 0);
                }
            }
        }
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.editorPane = new JEditorPane();
        this.buttonPanel = new JPanel();
        this.homeButton = new JButton();
        this.backButton = new JButton();
        this.closeButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HtmlViewDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setText(" ");
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.jScrollPane1.setViewportView(this.editorPane);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.homeButton.setText("Home");
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlViewDialog.this.homeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.homeButton);
        this.backButton.setText("Back");
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlViewDialog.this.backButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.backButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlViewDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        this.backButton.setEnabled(false);
        if (this.m_lastURL == null) {
            return;
        }
        try {
            this.editorPane.setPage(this.m_lastURL);
        }
        catch (IOException ioExc) {
            System.err.println("E: IO Exception: " + ioExc.toString());
        }
        this.m_lastURL = null;
    }

    private void homeButtonActionPerformed(ActionEvent evt) {
        this.backButton.setEnabled(false);
        this.m_lastURL = null;
        if (this.m_homeURL == null) {
            return;
        }
        try {
            this.editorPane.setPage(this.m_homeURL);
        }
        catch (IOException ioExc) {
            System.err.println("E: IO Exception: " + ioExc.toString());
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

