/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.webexport.ImageMagickExporter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import magick.MagickImage;
import magick.MagickProducer;

public class ImageViewDialog
extends JDialog {
    private Color m_errorColor;
    private FileObject m_fileObj;
    private BufferedImage m_image;
    private Image m_scaledImage;
    private MagickImage m_MImage;
    private MagickImage m_scaledMImage;
    private ImageIcon m_imageIcon;
    private ImageIcon m_scaledImageIcon;
    private Dimension m_imgSize;
    private Dimension m_scaledSize;
    private ImageMagickExporter m_magick;
    private JScrollPane imgViewScrollPane;
    private JLabel titleLabel;
    private JLabel westSpacer;
    private JLabel sepLabel;
    private JButton origSizeButton;
    private JLabel sizeLabel;
    private JPanel buttonPanel;
    private JPanel imgViewPanel;
    private JPanel bottomPanel;
    private JLabel imageLabel;
    private JButton fitToWindowButton;
    private JButton closeButton;
    private JLabel eastSpacer;

    public ImageViewDialog(FileObject fileObj, Dialog parent, boolean modal) {
        super(parent, modal);
        parent.setCursor(new Cursor(3));
        this.initialize(fileObj);
        parent.setCursor(new Cursor(0));
    }

    public ImageViewDialog(FileObject fileObj, Frame parent, boolean modal) {
        super(parent, modal);
        parent.setCursor(new Cursor(3));
        this.initialize(fileObj);
        parent.setCursor(new Cursor(0));
    }

    private void initialize(FileObject fileObj) {
        this.m_fileObj = fileObj;
        this.m_imgSize = new Dimension(0, 0);
        this.m_scaledSize = new Dimension(0, 0);
        this.m_image = null;
        this.m_scaledImage = null;
        this.m_scaledMImage = null;
        this.m_MImage = null;
        this.m_scaledImageIcon = null;
        this.m_imageIcon = null;
        this.m_errorColor = new Color(153, 51, 51);
        this.m_magick = null;
        if (this.m_fileObj.isImageMagickRequiredForDisplay() && ImageMagickExporter.isImageMagickAvailable()) {
            this.m_magick = new ImageMagickExporter();
        }
        this.initComponents();
        String str = this.m_fileObj.getTitlePlain();
        if (str.length() > 0) {
            str = str + " - ";
        }
        str = str + "Image View";
        this.setTitle(str);
        this.titleLabel.setText(this.m_fileObj.getFullPath());
        try {
            this.getOriginalSizeImage();
            str = this.m_imageIcon != null ? " " + this.m_imgSize.width + " x " + this.m_imgSize.height + " pixels" : "";
        }
        catch (OutOfMemoryError me) {
            this.m_image = null;
            this.m_scaledImage = null;
            this.m_scaledMImage = null;
            this.m_MImage = null;
            this.m_scaledImageIcon = null;
            this.m_imageIcon = null;
            Runtime.getRuntime().gc();
            str = "Out of memory while reading image - Please close the window.";
            this.sizeLabel.setForeground(this.m_errorColor);
            this.fitToWindowButton.setEnabled(false);
            this.origSizeButton.setEnabled(false);
            Runtime.getRuntime().gc();
        }
        catch (Exception e) {
            str = "Cannot load original image: " + e.getMessage();
            this.sizeLabel.setForeground(this.m_errorColor);
            this.fitToWindowButton.setEnabled(false);
            this.origSizeButton.setEnabled(false);
        }
        this.sizeLabel.setText(str);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension siz = tk.getScreenSize();
        Rectangle frameRect = new Rectangle();
        int newWidth = this.m_imgSize.width > 0 && this.m_imgSize.width < 2500 ? this.m_imgSize.width * siz.height / this.m_imgSize.height - 60 : siz.width;
        frameRect.width = newWidth < siz.width ? newWidth : siz.width;
        frameRect.height = siz.height;
        frameRect.x = 0;
        frameRect.y = 0;
        this.setBounds(frameRect);
        if (this.m_imgSize.width > 2500 || this.m_imgSize.height > 2500) {
            this.fitToWindowButton.setEnabled(false);
            this.origSizeButtonActionPerformed(null);
            str = str + " (big image - resize buttons disabled)";
            this.sizeLabel.setText(str);
        } else {
            this.fitToWindowButtonActionPerformed(null);
            Runtime.getRuntime().gc();
        }
    }

    private ImageIcon getOriginalSizeImage() throws Exception {
        if (this.m_imageIcon != null) {
            return this.m_imageIcon;
        }
        if (this.m_magick != null) {
            try {
                this.m_MImage = this.m_magick.readImage(this.m_fileObj.getFullPath());
                this.m_imgSize = this.m_MImage.getDimension();
                Image img = this.createImage(new MagickProducer(this.m_MImage));
                MediaTracker track = new MediaTracker(this);
                track.addImage(img, 0);
                try {
                    track.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.m_imageIcon = new ImageIcon(img);
                return this.m_imageIcon;
            }
            catch (Exception ex) {
                System.err.println("E: JM: Cannot read image:");
                ex.printStackTrace();
            }
        }
        this.m_image = ImageIO.read(new File(this.m_fileObj.getFullPath()));
        this.m_imgSize.width = this.m_image.getWidth();
        this.m_imgSize.height = this.m_image.getHeight();
        this.m_imageIcon = new ImageIcon(this.m_image);
        return this.m_imageIcon;
    }

    private ImageIcon getScaledImage() throws Exception {
        if (this.m_scaledImageIcon != null) {
            return this.m_scaledImageIcon;
        }
        if (this.m_magick != null) {
            try {
                this.m_scaledMImage = this.m_MImage.scaleImage(this.m_scaledSize.width, this.m_scaledSize.height);
                Image img = this.createImage(new MagickProducer(this.m_scaledMImage));
                MediaTracker track = new MediaTracker(this);
                track.addImage(img, 0);
                try {
                    track.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.m_scaledImageIcon = new ImageIcon(img);
                return this.m_scaledImageIcon;
            }
            catch (Exception ex) {
                System.err.println("E: JM: Cannot resize image to (" + this.m_scaledSize.width + " x " + this.m_scaledSize.height + ")");
                ex.printStackTrace();
                this.m_magick = null;
                this.m_MImage = null;
                this.m_imageIcon = null;
                this.getOriginalSizeImage();
            }
        }
        if (this.m_image == null) {
            return null;
        }
        this.m_scaledImage = this.m_image.getScaledInstance(this.m_scaledSize.width, this.m_scaledSize.height, 16);
        MediaTracker track = new MediaTracker(this);
        track.addImage(this.m_scaledImage, 0);
        try {
            track.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_scaledImageIcon = new ImageIcon(this.m_scaledImage);
        return this.m_scaledImageIcon;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.westSpacer = new JLabel();
        this.eastSpacer = new JLabel();
        this.imgViewPanel = new JPanel();
        this.imgViewScrollPane = new JScrollPane();
        this.imageLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.sizeLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.fitToWindowButton = new JButton();
        this.origSizeButton = new JButton();
        this.sepLabel = new JLabel();
        this.closeButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ImageViewDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setText(" ");
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.westSpacer.setText(" ");
        this.getContentPane().add((Component)this.westSpacer, "West");
        this.eastSpacer.setText(" ");
        this.getContentPane().add((Component)this.eastSpacer, "East");
        this.imgViewPanel.setLayout(new BorderLayout());
        this.imgViewScrollPane.setMinimumSize(new Dimension(55, 55));
        this.imgViewScrollPane.setPreferredSize(new Dimension(1300, 1300));
        this.imgViewScrollPane.setViewportView(this.imageLabel);
        this.imgViewPanel.add((Component)this.imgViewScrollPane, "Center");
        this.getContentPane().add((Component)this.imgViewPanel, "Center");
        this.bottomPanel.setLayout(new BorderLayout());
        this.sizeLabel.setText("3000 x 3000 pixels");
        this.bottomPanel.add((Component)this.sizeLabel, "West");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.fitToWindowButton.setText("Fit to Window");
        this.fitToWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewDialog.this.fitToWindowButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.fitToWindowButton);
        this.origSizeButton.setText("Original Size");
        this.origSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewDialog.this.origSizeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.origSizeButton);
        this.sepLabel.setText(" ");
        this.buttonPanel.add(this.sepLabel);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.bottomPanel.add((Component)this.buttonPanel, "Center");
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.pack();
    }

    private void fitToWindowButtonActionPerformed(ActionEvent evt) {
        if (this.m_magick == null && this.m_image == null || this.m_magick != null && this.m_MImage == null) {
            return;
        }
        try {
            Dimension viewSize = this.imgViewScrollPane.getSize();
            viewSize.width -= 10;
            viewSize.height -= 20;
            if (viewSize.width >= this.m_imgSize.width && viewSize.height >= this.m_imgSize.height) {
                this.origSizeButtonActionPerformed(evt);
                return;
            }
            int newHeight = this.m_imgSize.height * viewSize.width / this.m_imgSize.width;
            if (newHeight > viewSize.height) {
                viewSize.width = this.m_imgSize.width * viewSize.height / this.m_imgSize.height;
            } else {
                viewSize.height = this.m_imgSize.height * viewSize.width / this.m_imgSize.width;
            }
            if (!this.m_scaledSize.equals(viewSize) || this.m_scaledImageIcon == null) {
                this.m_scaledSize = viewSize;
                this.m_scaledImage = null;
                this.m_scaledMImage = null;
                this.m_scaledImageIcon = null;
                Runtime.getRuntime().gc();
                this.getScaledImage();
            }
            if (this.m_scaledImageIcon != null) {
                this.imageLabel.setIcon(this.m_scaledImageIcon);
            } else {
                this.imageLabel.setText("Scaled image not available");
            }
        }
        catch (OutOfMemoryError me) {
            Runtime.getRuntime().gc();
            this.sizeLabel.setForeground(this.m_errorColor);
            this.sizeLabel.setText("Out of memory while scaling image - Please close the window.");
            this.fitToWindowButton.setEnabled(false);
            this.origSizeButton.setEnabled(false);
            this.origSizeButtonActionPerformed(evt);
            Runtime.getRuntime().gc();
        }
        catch (Exception e) {
            String str = "Cannot load scaled image: " + e.getMessage();
            e.printStackTrace();
            this.sizeLabel.setText(str);
            this.sizeLabel.setForeground(this.m_errorColor);
            this.fitToWindowButton.setEnabled(false);
        }
    }

    private void origSizeButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.m_imageIcon != null) {
                this.imageLabel.setIcon(this.m_imageIcon);
                Dimension siz = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle frameRect = this.getBounds();
                if (frameRect.width < siz.width) {
                    frameRect.width = siz.width;
                    frameRect.x = 0;
                    this.setBounds(frameRect);
                    this.validate();
                }
            } else {
                this.imageLabel.setText("Image not available");
            }
        }
        catch (OutOfMemoryError me) {
            Runtime.getRuntime().gc();
            this.sizeLabel.setForeground(this.m_errorColor);
            this.sizeLabel.setText("Out of memory - Please close the window.");
            this.fitToWindowButton.setEnabled(false);
            this.origSizeButton.setEnabled(false);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        this.m_imgSize = new Dimension(0, 0);
        this.m_scaledSize = new Dimension(0, 0);
        this.m_image = null;
        this.m_scaledImage = null;
        this.m_scaledMImage = null;
        this.m_MImage = null;
        this.m_scaledImageIcon = null;
        this.m_imageIcon = null;
        Runtime.getRuntime().gc();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
        this.m_imgSize = new Dimension(0, 0);
        this.m_scaledSize = new Dimension(0, 0);
        this.m_image = null;
        this.m_scaledImage = null;
        this.m_scaledMImage = null;
        this.m_MImage = null;
        this.m_scaledImageIcon = null;
        this.m_imageIcon = null;
        Runtime.getRuntime().gc();
    }
}

