/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.panel;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.dir.SeriesContainer;
import com.dgrossmann.photo.dir.persist.PersistException;
import com.dgrossmann.photo.ui.ExplorerMainFrame;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DirTreeModel
implements TreeModel {
    private ExplorerMainFrame m_mainFrame;
    private List<TreeModelListener> m_treeModelListeners;
    private SeriesContainer m_seriesContainer;
    private FileObject m_root;
    private DirectoryObject[] m_seriesDirs;

    public DirTreeModel(SeriesContainer seriesContainer, ExplorerMainFrame parent) {
        this.m_seriesContainer = seriesContainer;
        this.m_mainFrame = parent;
        this.m_treeModelListeners = new ArrayList<TreeModelListener>();
        this.m_root = new FileObject("Series Directories", null);
        this.refresh(null);
    }

    public void refresh(AbstractFSObject node) {
        if (node == null) {
            this.m_seriesDirs = this.m_seriesContainer.getSeriesDirectories();
            this.fireTreeStructureChanged(null);
            return;
        }
        this.fireTreeStructureChanged(node);
    }

    public void fireTreeStructureChanged(AbstractFSObject node) {
        int i;
        Object[] path;
        int len = this.m_treeModelListeners.size();
        if (node == null) {
            path = new Object[]{this.m_root};
        } else {
            ArrayList<AbstractFSObject> nodes = new ArrayList<AbstractFSObject>();
            while (node.getParent() != null) {
                nodes.add(node);
                node = node.getParent();
            }
            nodes.add(node);
            nodes.add(this.m_root);
            path = new Object[nodes.size()];
            int j = 0;
            for (i = nodes.size() - 1; i >= 0; --i) {
                path[j++] = nodes.get(i);
            }
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, path);
        for (i = 0; i < len; ++i) {
            this.m_treeModelListeners.get(i).treeStructureChanged(event);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.m_treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.m_treeModelListeners.remove(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof FileObject) {
            return this.m_seriesDirs[index];
        }
        DirectoryObject de = (DirectoryObject)parent;
        return de.getSubDirAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof FileObject) {
            return this.m_seriesDirs.length;
        }
        DirectoryObject de = (DirectoryObject)parent;
        return de.getSubDirCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        DirectoryObject ch = (DirectoryObject)child;
        if (parent instanceof FileObject) {
            for (int i = 0; i < this.m_seriesDirs.length; ++i) {
                if (ch != this.m_seriesDirs[i]) continue;
                return i;
            }
            return -1;
        }
        DirectoryObject de = (DirectoryObject)parent;
        return de.getIndexOfSubDir(ch);
    }

    @Override
    public Object getRoot() {
        return this.m_root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return false;
    }

    public DirectoryObject getDirObjectForPath(TreePath treePath, boolean bExact) {
        int i;
        String str;
        if (treePath == null) {
            return null;
        }
        DirectoryObject dirObj = null;
        Object[] path = treePath.getPath();
        if (path.length >= 2) {
            str = path[1].toString();
            for (i = 0; i < this.m_seriesDirs.length; ++i) {
                if (!this.m_seriesDirs[i].getFileName().equalsIgnoreCase(str)) continue;
                dirObj = this.m_seriesDirs[i];
                break;
            }
        }
        block1: for (i = 2; dirObj != null && i < path.length; ++i) {
            str = path[i].toString();
            Iterator<DirectoryObject> subDirIter = dirObj.getSubDirIterator();
            if (bExact) {
                dirObj = null;
            }
            while (subDirIter.hasNext()) {
                DirectoryObject d = subDirIter.next();
                if (!d.getFileName().equalsIgnoreCase(str)) continue;
                dirObj = d;
                continue block1;
            }
        }
        return dirObj;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object newValue) {
        File f;
        DirectoryObject dirObj = this.getDirObjectForPath(treePath, true);
        if (dirObj == null || newValue == null) {
            return;
        }
        String str = newValue.toString().trim();
        if (dirObj.getParent() != null && (f = new File(dirObj.getParent().getFileName(), str)).exists()) {
            JOptionPane.showMessageDialog(this.m_mainFrame, "Cannot rename as a directory or file with the following name already exists:\n" + f.getAbsolutePath(), "J Photo-Explorer", 2);
            return;
        }
        if (this.m_mainFrame != null) {
            this.m_mainFrame.renameExportedFiles(dirObj, null, str);
        }
        dirObj.setFileName(str, true);
        try {
            this.m_seriesContainer.saveSeries(dirObj, true);
        }
        catch (PersistException pe) {
            JOptionPane.showMessageDialog(this.m_mainFrame, pe.getMessage(), "J Photo-Explorer", 0);
        }
        this.m_mainFrame.getDirContentsPanel().refresh();
    }
}

