/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.panel;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.settings.Settings;
import com.dgrossmann.photo.ui.ExplorerMainFrame;
import com.dgrossmann.photo.ui.ImageHolder;
import com.dgrossmann.photo.ui.dialog.DateChooserDialog;
import com.dgrossmann.photo.ui.dialog.PropertiesDialog;
import com.dgrossmann.photo.ui.panel.AbstractExplorerPanel;
import com.dgrossmann.photo.ui.panel.PanelTitleChangeListener;
import com.dgrossmann.photo.webexport.ExportException;
import com.dgrossmann.photo.webexport.ExportFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PropertyPanel
extends AbstractExplorerPanel
implements FocusListener,
PanelTitleChangeListener {
    private static final String PROPS_OVERVIEW = "Properties";
    private static final String PROPS_SERIES = "Series";
    private static final String PROPS_DIR = "Group";
    private static final String PROPS_FILE = "File";
    private static final String PROPS_REFERENCE = "Reference";
    private static final String PROPS_SEPARATOR = "Separator";
    private ImageHolder m_imgHolder;
    private AbstractFSObject m_currentFSObject = null;
    private boolean m_bIsPreviewShowing;
    private File[] m_exportedFiles;
    private static final String PROP_SHOW_PREVIEW = "property_pane.show_preview";
    public JPanel aspectsPanel;
    public JLabel beginDateLabel;
    public JTextField beginDateText;
    public JScrollPane descScrollPane;
    public JTextArea descTextArea;
    public JPanel fileSizePanel;
    public JLabel indexSizeLabel;
    public JLabel indexSizeTextLabel;
    public JLabel mainSizeLabel;
    public JLabel mainSizeTextLabel;
    public JPanel previewCenterPanel;
    public JLabel previewImgLabel;
    public JPanel previewPanel;
    public JPanel propertyPanel;
    public JButton propsButton;
    public JButton setBeginDateButton;
    public JLabel titleLabel;
    public JTextField titleText;

    public PropertyPanel(ExplorerMainFrame frm) {
        super(frm, PROPS_OVERVIEW);
        this.m_imgHolder = frm.getImageHolder();
        this.m_exportedFiles = null;
        this.m_bIsPreviewShowing = false;
        this.initComponents();
        this.add((Component)this.getTitleLabel(), "North");
        this.titleText.addFocusListener(this);
        this.descTextArea.addFocusListener(this);
        this.setCurrentFSObjects(null);
    }

    @Override
    public void setupComponents() {
    }

    @Override
    public void setActiveColors() {
        if (this.getCurrentFSObjects() != null && this.getCurrentFSObjects().size() > 0) {
            super.setActiveColors();
        } else {
            super.setInactiveColors();
        }
    }

    @Override
    public void setCurrentFSObjects(List<AbstractFSObject> currentFsObjects) {
        if (currentFsObjects != null && currentFsObjects.equals(this.getCurrentFSObjects())) {
            return;
        }
        this.setAttributesFromControls(null);
        super.setCurrentFSObjects(currentFsObjects);
        this.m_currentFSObject = currentFsObjects == null || currentFsObjects.size() != 1 ? null : currentFsObjects.get(0);
        this.refresh();
    }

    private AbstractFSObject getCurrentFSObject() {
        return this.m_currentFSObject;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setAttributesFromControls(e);
        this.firePropertiesChanged(this.m_currentFSObject);
    }

    private void setAttributesFromControls(EventObject e) {
        String val;
        if (this.m_currentFSObject == null) {
            return;
        }
        if (!(e != null && e.getSource() != this.titleText || (val = this.titleText.getText()) == null || val.equals(this.m_currentFSObject.get("title")))) {
            this.m_currentFSObject.set("title", val.trim());
        }
        if (!(e != null && e.getSource() != this.descTextArea || (val = this.descTextArea.getText()) == null || val.equals(this.m_currentFSObject.get("description")))) {
            this.m_currentFSObject.set("description", val.trim());
        }
        if (this.m_currentFSObject instanceof FileObject) {
            DirectoryObject parentDir = (DirectoryObject)this.m_currentFSObject.getParent();
            if (parentDir != null) {
                parentDir.setChanged();
            }
        } else if (this.m_currentFSObject instanceof DirectoryObject) {
            ((DirectoryObject)this.m_currentFSObject).setChanged();
        }
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void refresh() {
        this.mainSizeTextLabel.setText("--");
        this.indexSizeTextLabel.setText("--");
        this.m_exportedFiles = null;
        if (this.m_currentFSObject == null) {
            this.disableControls(true);
            this.setInactiveColors();
            List<AbstractFSObject> allFSObjs = this.getCurrentFSObjects();
            if (allFSObjs == null || allFSObjs.size() == 0 || allFSObjs.size() == 1 && allFSObjs.get(0) == null) {
                this.setTitle(PROPS_OVERVIEW);
                this.setInactiveColors();
            } else {
                String title = Integer.toString(allFSObjs.size()) + " objects selected";
                this.setTitle(title);
                this.setActiveColors();
            }
        } else {
            this.setActiveColors();
            String prefix = "";
            if (this.m_currentFSObject instanceof DirectoryObject) {
                prefix = ((DirectoryObject)this.m_currentFSObject).getParent() == null ? PROPS_SERIES : PROPS_DIR;
            } else if (this.m_currentFSObject instanceof FileObject) {
                FileObject fileObj = (FileObject)this.m_currentFSObject;
                if (fileObj.isSeparator()) {
                    this.setTitle(PROPS_SEPARATOR);
                    this.disableControls(true);
                    this.fillPreview();
                    return;
                }
                prefix = fileObj.isReference() ? PROPS_REFERENCE : PROPS_FILE;
            }
            this.enableControls();
            this.titleText.setText(AbstractFSObject.transformAccents(this.m_currentFSObject.getTitle(true), false));
            this.beginDateText.setText(this.m_currentFSObject.getBeginDate(true));
            this.descTextArea.setText(AbstractFSObject.transformAccents(this.m_currentFSObject.get("description"), false));
            this.descTextArea.select(0, 0);
            String panelTitle = this.m_currentFSObject.getTitlePlain();
            if (panelTitle.length() < 30) {
                panelTitle = prefix + " \"" + panelTitle + "\"";
            }
            if (this.m_currentFSObject instanceof DirectoryObject && panelTitle.length() < 25) {
                String title = this.m_currentFSObject.getTitlePlain();
                String dirName = this.m_currentFSObject.getFileName();
                if (title != null && !title.equals(dirName)) {
                    panelTitle = panelTitle + " (\"" + dirName + "\")";
                }
            }
            this.setTitle(panelTitle);
            if (this.m_currentFSObject instanceof FileObject) {
                this.m_exportedFiles = ExportFactory.getExport(this.getFrame().getSettings(), this.getFrame().getSeriesContainer(), this).getExportedFiles(this.m_currentFSObject);
                if (this.m_exportedFiles != null) {
                    if (this.m_exportedFiles[0] != null) {
                        long len = this.m_exportedFiles[0].length() / 1024L;
                        if (len <= 0L) {
                            len = 1L;
                        }
                        this.mainSizeTextLabel.setText(Long.toString(len) + " KB");
                    }
                    if (this.m_exportedFiles[1] != null) {
                        long len = this.m_exportedFiles[1].length() / 1024L;
                        if (len <= 0L) {
                            len = 1L;
                        }
                        this.indexSizeTextLabel.setText(Long.toString(len) + " KB");
                    }
                }
            }
        }
        this.fillPreview();
    }

    @Override
    public void onTitleSelectionChanged(int panelId) {
        this.m_bIsPreviewShowing = panelId == 1;
        this.fillPreview();
    }

    private void fillPreview() {
        if (this.m_currentFSObject == null || !this.m_bIsPreviewShowing || this.m_currentFSObject instanceof FileObject && ((FileObject)this.m_currentFSObject).isSeparator()) {
            this.previewImgLabel.setText(null);
            this.previewImgLabel.setIcon(null);
            return;
        }
        this.getFrame().setCursor(new Cursor(3));
        this.m_imgHolder.addTransientScaleCategory("prop");
        Dimension pSize = this.previewPanel.getSize();
        pSize.width = pSize.height;
        this.previewPanel.setSize(pSize);
        ImageIcon previewImg = this.m_imgHolder.getTypeImage(this.m_currentFSObject, true, "prop", pSize.height, this, true);
        if (previewImg != null) {
            this.previewImgLabel.setIcon(previewImg);
            if (this.m_currentFSObject instanceof FileObject && ((FileObject)this.m_currentFSObject).getFileType() == 1) {
                this.previewImgLabel.setToolTipText(null);
            }
        }
        this.previewImgLabel.setText(null);
        String str = this.m_imgHolder.getLastError();
        if (str.length() > 0) {
            JOptionPane.showMessageDialog(this, str, "J Photo-Explorer", 0);
            this.previewImgLabel.setText("Preview not available");
        }
        if (this.m_currentFSObject instanceof FileObject && ((FileObject)this.m_currentFSObject).getFileType() == 2) {
            this.previewImgLabel.setText("Preview not available");
        }
        this.getFrame().setCursor(new Cursor(0));
    }

    private void disableControls(boolean bSetDefaultTexts) {
        this.titleText.setEnabled(false);
        this.titleText.setEditable(false);
        this.descTextArea.setEnabled(false);
        this.descTextArea.setEditable(false);
        this.propsButton.setEnabled(false);
        this.setBeginDateButton.setEnabled(false);
        if (bSetDefaultTexts) {
            this.titleText.setText("");
            this.beginDateText.setText("");
            this.descTextArea.setText("");
        }
    }

    private void enableControls() {
        this.titleText.setEnabled(true);
        this.titleText.setEditable(true);
        this.descTextArea.setEnabled(true);
        this.descTextArea.setEditable(true);
        this.propsButton.setEnabled(true);
        this.setBeginDateButton.setEnabled(true);
    }

    @Override
    public void loadSettings(Settings settings) {
        this.m_bIsPreviewShowing = settings.getBoolean(PROP_SHOW_PREVIEW, false);
        this.getTitleLabel().setPanelComponents(this.aspectsPanel, this.propertyPanel, this.previewPanel, this.m_bIsPreviewShowing);
        this.getTitleLabel().addChangeListener(this);
    }

    @Override
    public void saveSettings(Settings settings) {
        settings.setBoolean(PROP_SHOW_PREVIEW, this.m_bIsPreviewShowing);
    }

    private void initComponents() {
        this.aspectsPanel = new JPanel();
        this.propertyPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleText = new JTextField();
        this.propsButton = new JButton();
        this.beginDateLabel = new JLabel();
        this.beginDateText = new JTextField();
        this.setBeginDateButton = new JButton();
        this.descScrollPane = new JScrollPane();
        this.descTextArea = new JTextArea();
        this.previewPanel = new JPanel();
        this.previewCenterPanel = new JPanel();
        this.previewImgLabel = new JLabel();
        this.fileSizePanel = new JPanel();
        this.mainSizeLabel = new JLabel();
        this.mainSizeTextLabel = new JLabel();
        this.indexSizeLabel = new JLabel();
        this.indexSizeTextLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.aspectsPanel.setLayout(new CardLayout());
        this.propertyPanel.setLayout(new GridBagLayout());
        this.titleLabel.setText("Title:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.propertyPanel.add((Component)this.titleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 4);
        this.propertyPanel.add((Component)this.titleText, gridBagConstraints);
        this.propsButton.setText(PROPS_OVERVIEW);
        this.propsButton.setToolTipText("Displays the properties dialog");
        this.propsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyPanel.this.propsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 6, 0, 4);
        this.propertyPanel.add((Component)this.propsButton, gridBagConstraints);
        this.beginDateLabel.setText("Date:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.propertyPanel.add((Component)this.beginDateLabel, gridBagConstraints);
        this.beginDateText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 2);
        this.propertyPanel.add((Component)this.beginDateText, gridBagConstraints);
        this.setBeginDateButton.setText(" ... ");
        this.setBeginDateButton.setToolTipText("Sets the begin date");
        this.setBeginDateButton.setMaximumSize(new Dimension(30, 20));
        this.setBeginDateButton.setMinimumSize(new Dimension(30, 20));
        this.setBeginDateButton.setPreferredSize(new Dimension(30, 20));
        this.setBeginDateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyPanel.this.setBeginDateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.propertyPanel.add((Component)this.setBeginDateButton, gridBagConstraints);
        this.descTextArea.setColumns(20);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setRows(3);
        this.descTextArea.setWrapStyleWord(true);
        this.descScrollPane.setViewportView(this.descTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.propertyPanel.add((Component)this.descScrollPane, gridBagConstraints);
        this.aspectsPanel.add((Component)this.propertyPanel, "normal");
        this.previewPanel.setLayout(new GridBagLayout());
        this.previewCenterPanel.setLayout(new BorderLayout());
        this.previewCenterPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.previewImgLabel.setForeground(new Color(102, 102, 102));
        this.previewImgLabel.setHorizontalAlignment(0);
        this.previewImgLabel.setToolTipText("Preview image (if available)");
        this.previewImgLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.previewImgLabel.setMinimumSize(new Dimension(100, 100));
        this.previewImgLabel.setPreferredSize(new Dimension(160, 160));
        this.previewCenterPanel.add((Component)this.previewImgLabel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.previewPanel.add((Component)this.previewCenterPanel, gridBagConstraints);
        this.aspectsPanel.add((Component)this.previewPanel, "preview");
        this.add((Component)this.aspectsPanel, "Center");
        this.fileSizePanel.setLayout(new GridBagLayout());
        this.mainSizeLabel.setText("Main Image:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 0);
        this.fileSizePanel.add((Component)this.mainSizeLabel, gridBagConstraints);
        this.mainSizeTextLabel.setText("--");
        this.mainSizeTextLabel.setPreferredSize(new Dimension(60, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 0);
        this.fileSizePanel.add((Component)this.mainSizeTextLabel, gridBagConstraints);
        this.indexSizeLabel.setText("Index Image:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        this.fileSizePanel.add((Component)this.indexSizeLabel, gridBagConstraints);
        this.indexSizeTextLabel.setText("--");
        this.indexSizeTextLabel.setPreferredSize(new Dimension(60, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 0);
        this.fileSizePanel.add((Component)this.indexSizeTextLabel, gridBagConstraints);
        this.add((Component)this.fileSizePanel, "South");
    }

    private void setBeginDateButtonActionPerformed(ActionEvent evt) {
        AbstractFSObject fsObj = this.getCurrentFSObject();
        if (fsObj == null) {
            return;
        }
        DateChooserDialog dlg = new DateChooserDialog((Frame)this.getFrame(), fsObj.get("date-begin"), "begin", true);
        if (!dlg.showDialog()) {
            return;
        }
        fsObj.set("date-begin", dlg.getDateString());
        this.beginDateText.setText(fsObj.getBeginDate(true));
        if (fsObj instanceof DirectoryObject) {
            ((DirectoryObject)fsObj).setChanged();
        }
        this.firePropertiesChanged(fsObj);
    }

    private void propsButtonActionPerformed(ActionEvent evt) {
        AbstractFSObject fsObj = this.getCurrentFSObject();
        if (fsObj == null) {
            return;
        }
        this.getFrame().save();
        boolean oldToExport = fsObj.isToExport();
        int oldQuality = fsObj.getConversionQuality();
        PropertiesDialog dlg = new PropertiesDialog(this.m_imgHolder, fsObj, this.m_exportedFiles, this.getFrame(), true);
        if (!dlg.showDialog()) {
            return;
        }
        if (fsObj instanceof FileObject && !fsObj.isToExport()) {
            try {
                ExportFactory.getExport(this.getFrame().getSettings(), this.getFrame().getSeriesContainer(), this).deleteExportedFiles(fsObj, 1);
            }
            catch (ExportException ignored) {}
        } else if (fsObj instanceof FileObject && (!oldToExport && fsObj.isToExport() || oldQuality != fsObj.getConversionQuality())) {
            this.getFrame().startExport(fsObj, true, true, true);
        }
        this.refresh();
        this.firePropertiesChanged(fsObj);
    }
}

