/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.webexport;

import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.webexport.BaseExporter;
import com.dgrossmann.photo.webexport.ExportException;
import com.dgrossmann.photo.webexport.ExportProgress;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import magick.DrawInfo;
import magick.ImageInfo;
import magick.Magick;
import magick.MagickImage;
import magick.PixelPacket;

public class ImageMagickExporter
extends BaseExporter {
    private static boolean s_bAvailabilityChecked = false;
    private static boolean s_bAvailable = false;

    @Override
    public String getDescription() {
        return "ImageMagick";
    }

    public static boolean isImageMagickAvailable() {
        if (s_bAvailabilityChecked) {
            return s_bAvailable;
        }
        s_bAvailabilityChecked = true;
        s_bAvailable = false;
        try {
            Rectangle rect = new Rectangle(0, 0, 80, 40);
            Magick.parseImageGeometry("50x50", rect);
            s_bAvailable = true;
            return true;
        }
        catch (NoClassDefFoundError cnf) {
            System.err.println("I: ImageMagick (JMagick) class \"Magick\" not found");
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("I: ImageMagick (JMagick) native method library not found");
        }
        catch (Exception e) {
            System.err.println("I: Exception while accessing ImageMagick (JMagick) class \"Magick\":\n" + e);
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return ImageMagickExporter.isImageMagickAvailable();
    }

    public MagickImage readImage(String fileName) throws Exception {
        ImageInfo info = new ImageInfo(fileName);
        info.setColorspace(1);
        return new MagickImage(info);
    }

    public void writeScaledImage(MagickImage origImage, Dimension newSize, String fileName) throws Exception {
        if (!origImage.setImageAttribute("filter", "Cubic")) {
            System.err.println("E: JM: Cannot set filter attribute");
        }
        MagickImage scaledImage = origImage.scaleImage(newSize.width, newSize.height);
        scaledImage.setCompression(8);
        scaledImage.setFileName(fileName);
        ImageInfo info = new ImageInfo(fileName);
        scaledImage.writeImage(info);
    }

    @Override
    protected void exportFile(FileObject fileObj, ExportProgress progress) throws ExportException {
        try {
            MagickImage scaledImage;
            String outFileName;
            ImageInfo info = new ImageInfo(fileObj.getFullPath());
            info.setColorspace(1);
            MagickImage origImage = new MagickImage(info);
            Dimension size = origImage.getDimension();
            progress.setOriginalSize(size);
            this.fillImageSizes(progress);
            if (!origImage.setImageAttribute("filter", "Cubic")) {
                System.err.println("E: JM: Cannot set filter attribute");
            }
            if (!progress.isMainUpToDate()) {
                size = progress.getMainSize();
                outFileName = progress.getOutputDirectory() + File.separator + progress.getMainFileName();
                scaledImage = origImage.scaleImage(size.width, size.height);
                scaledImage.setCompression(5);
                scaledImage.setFileName(outFileName);
                String copyrightStr = this.getCopyrightString(fileObj);
                if (copyrightStr != null) {
                    DrawInfo drawInfo = new DrawInfo(new ImageInfo());
                    drawInfo.setFill(PixelPacket.queryColorDatabase("black"));
                    drawInfo.setOpacity(0);
                    drawInfo.setPointsize(11.0);
                    drawInfo.setFont("Arial");
                    drawInfo.setTextAntialias(false);
                    drawInfo.setText(copyrightStr);
                    drawInfo.setGeometry("+" + (size.width - 130) + "+" + (size.height - 2));
                    scaledImage.annotateImage(drawInfo);
                    drawInfo = new DrawInfo(new ImageInfo());
                    drawInfo.setFill(PixelPacket.queryColorDatabase("white"));
                    drawInfo.setOpacity(0);
                    drawInfo.setPointsize(11.0);
                    drawInfo.setFont("Arial");
                    drawInfo.setTextAntialias(false);
                    drawInfo.setText(copyrightStr);
                    drawInfo.setGeometry("+" + (size.width - 131) + "+" + (size.height - 3));
                    scaledImage.annotateImage(drawInfo);
                }
                info = new ImageInfo(outFileName);
                info.setQuality(this.getConversionQuality(fileObj, true));
                scaledImage.writeImage(info);
            }
            if (!progress.isIndexUpToDate()) {
                size = progress.getIndexSize();
                outFileName = progress.getOutputDirectory() + File.separator + progress.getIndexFileName();
                scaledImage = origImage.scaleImage(size.width, size.height);
                scaledImage.setCompression(5);
                scaledImage.setFileName(outFileName);
                info = new ImageInfo(outFileName);
                info.setQuality(this.getConversionQuality(fileObj, false));
                scaledImage.writeImage(info);
            }
        }
        catch (Exception e) {
            ExportException exc = new ExportException(fileObj, e);
            exc.log();
            throw exc;
        }
    }
}

