/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: PersistFactory
    Created: 9 January, 2003
        $Id: PersistFactory.java 52 2006-02-10 18:57:12Z Dirk $
  $Revision: 52 $
      $Date: 2006-02-10 19:57:12 +0100 (Fr, 10 Feb 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.dir.persist;

import com.dgrossmann.photo.settings.Settings;

/**
 * Factory for objects that can persist series and group information as well
 * as program settings.
 */
public class PersistFactory
{
    public static boolean s_bSettingsLoaded = false;

    /**
     * Loads the persistence-relevant settings on start-up.
     * @param settings - The settings object.
     */
    public static synchronized void loadSettings (Settings settings)
    {
        // The settings should be loaded only once.
        if (s_bSettingsLoaded)
            return;
        s_bSettingsLoaded = true;
        DirPersistDecorator.loadSettings(settings);   
    } // loadSettings
    
    /**
     * Gets the persist object.
     * @param settings - Settings object
     * @return Persist object implementing the <tt>IDirPersist</tt> interface
     */
    public static IDirPersist getPersist (Settings settings)
    {
        IDirPersist p = new DirPersistDecorator(settings);
        return p;
    } // getPersist
} // PersistFactory
