/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: ContentsTableMouseListener
    Created: 2 January, 2003
        $Id: ContentsTableMouseListener.java 56 2006-02-12 17:00:28Z Dirk $
  $Revision: 56 $
      $Date: 2006-02-12 18:00:28 +0100 (So, 12 Feb 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui.panel.contents;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * Mouse listener for the double-click (showing the file properties dialog) and
 * the context menu in the file list table.
 */
public class ContentsTableMouseListener extends MouseAdapter
{
    private ContentsPanel m_parentPanel;
    
    /**
     * Creates a new <tt>ContentsTableMouseListener</tt> instance.
     * @param parentPanel - Parent main frame object
     */
    public ContentsTableMouseListener (ContentsPanel parentPanel)
    {
        super();
        m_parentPanel = parentPanel;
    } // ContentsTableMouseListener
    
    /**
     * Mouse pressed handler that might show the file context menu.
     * @param e Mouse event
     * */
    public void mousePressed (MouseEvent e)
    {
        if (e.isPopupTrigger())
            m_parentPanel.showFileContextMenu(e.getX(), e.getY());
    } // mousePressed
    
    /**
     * Mouse pressed handler that shows the file context menu.
     * @param e Mouse event
     */
    public void mouseReleased (MouseEvent e)
    {
        if (e.isPopupTrigger())
            m_parentPanel.showFileContextMenu(e.getX(), e.getY());
    } // mouseReleased
    
    /**
     * Mouse clicked handler that shows the file properties dialog.
     * @param e Mouse event
     */
    public void mouseClicked (MouseEvent e)
    {
        if (e.getClickCount() > 1)
            m_parentPanel.onDoubleClickListTable();
    } // mouseClicked
} // ContentsTableMouseListener
